/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.dnd;

import com.ait.lienzo.client.core.event.INodeXYEvent;
import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.event.NodeMouseMoveHandler;
import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.dom.client.Style;
import java.util.ArrayList;
import java.util.List;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.IsRowDragHandle;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

public class GridWidgetDnDMouseMoveHandler
implements NodeMouseMoveHandler {
    private static final int COLUMN_RESIZE_HANDLE_SENSITIVITY = 5;
    private final GridLayer layer;
    private final GridWidgetDnDHandlersState state;

    public GridWidgetDnDMouseMoveHandler(GridLayer layer, GridWidgetDnDHandlersState state) {
        this.layer = layer;
        this.state = state;
    }

    public void onNodeMouseMove(NodeMouseMoveEvent event) {
        switch (this.state.getOperation()) {
            case GRID_MOVE: {
                break;
            }
            case COLUMN_RESIZE: {
                this.handleColumnResize(event);
                break;
            }
            case COLUMN_MOVE: {
                this.handleColumnMove(event);
                break;
            }
            case ROW_MOVE: {
                this.handleRowMove(event);
                break;
            }
            default: {
                this.findGridColumn(event);
            }
        }
    }

    void findGridColumn(NodeMouseMoveEvent event) {
        this.state.reset();
        this.setCursor(this.state.getCursor());
        for (GridWidget gridWidget : this.layer.getGridWidgets()) {
            gridWidget.setDraggable(false);
            if (!gridWidget.isVisible() || !gridWidget.getModel().isColumnDraggingEnabled()) continue;
            Group header = gridWidget.getHeader();
            GridRenderer renderer = gridWidget.getRenderer();
            double headerHeight = renderer.getHeaderHeight();
            double headerRowsYOffset = this.getHeaderRowsYOffset(gridWidget, renderer);
            double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
            double headerMaxY = header == null ? headerHeight : headerHeight + header.getY();
            Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
            double cx = ap.getX();
            double cy = ap.getY();
            if (!this.layer.isGridPinned() && gridWidget.onDragHandle((INodeXYEvent)event)) {
                this.state.setActiveGridWidget(gridWidget);
                this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.GRID_MOVE_PENDING);
                continue;
            }
            if (cx < 0.0 || cx > gridWidget.getWidth() || cy < headerMinY || cy > gridWidget.getHeight()) continue;
            if (cy < headerMaxY) {
                this.findMovableColumns(gridWidget, headerHeight - headerRowsYOffset, headerMinY, cx, cy);
            } else {
                this.findMovableRows(gridWidget, cx, cy);
                this.findResizableColumn(gridWidget, cx);
            }
            if (this.layer.isGridPinned() || this.state.getActiveGridWidget() != null) continue;
            this.state.setActiveGridWidget(gridWidget);
            this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.GRID_MOVE_PENDING);
        }
        for (IMediator mediator : this.layer.getViewport().getMediators()) {
            mediator.setEnabled(this.state.getActiveGridWidget() == null);
        }
    }

    private double getHeaderRowsYOffset(GridWidget gridWidget, GridRenderer renderer) {
        GridData model = gridWidget.getModel();
        int headerRowCount = model.getHeaderRowCount();
        double headerHeight = renderer.getHeaderHeight();
        double headerRowHeight = renderer.getHeaderRowHeight();
        double headerRowsHeight = headerRowHeight * (double)headerRowCount;
        double headerRowsYOffset = headerHeight - headerRowsHeight;
        return headerRowsYOffset;
    }

    private void setCursor(Style.Cursor cursor) {
        for (IMediator mediator : this.layer.getViewport().getMediators()) {
            if (!(mediator instanceof RestrictedMousePanMediator) || !((RestrictedMousePanMediator)mediator).isDragging()) continue;
            return;
        }
        this.layer.getViewport().getElement().getStyle().setCursor(cursor);
        this.state.setCursor(cursor);
    }

    void findResizableColumn(GridWidget view, double cx) {
        double columnWidth;
        BaseGridRendererHelper rendererHelper = view.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return;
        }
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> bodyColumns = bodyBlockInformation.getColumns();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        double bodyX = bodyBlockInformation.getX();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double offsetX = floatingX;
        GridColumn<?> column = null;
        for (GridColumn<?> gridColumn : floatingColumns) {
            if (!gridColumn.isVisible()) continue;
            if (gridColumn.isResizable() && cx > (columnWidth = gridColumn.getWidth()) + offsetX - 5.0 && cx < columnWidth + offsetX + 5.0) {
                column = gridColumn;
                break;
            }
            offsetX += gridColumn.getWidth();
        }
        if (column == null) {
            offsetX = bodyX;
            for (GridColumn<?> gridColumn : bodyColumns) {
                if (!gridColumn.isVisible()) continue;
                if (gridColumn.isResizable()) {
                    columnWidth = gridColumn.getWidth();
                    if (offsetX + gridColumn.getWidth() > floatingX + floatingWidth && cx > columnWidth + offsetX - 5.0 && cx < columnWidth + offsetX + 5.0) {
                        column = gridColumn;
                        break;
                    }
                }
                offsetX += gridColumn.getWidth();
            }
        }
        if (column != null) {
            ArrayList activeColumns = new ArrayList();
            activeColumns.add(column);
            this.state.setActiveGridWidget(view);
            this.state.setActiveGridColumns(activeColumns);
            this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_RESIZE_PENDING);
            this.setCursor(Style.Cursor.COL_RESIZE);
        }
    }

    void findMovableColumns(GridWidget view, double headerRowsHeight, double headerMinY, double cx, double cy) {
        BaseGridRendererHelper rendererHelper = view.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return;
        }
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> allColumns = view.getModel().getColumns();
        List<GridColumn<?>> bodyColumns = bodyBlockInformation.getColumns();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        double bodyX = bodyBlockInformation.getX();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double offsetX = bodyX;
        for (int headerColumnIndex = 0; headerColumnIndex < bodyColumns.size(); ++headerColumnIndex) {
            GridColumn<?> gridColumn = bodyColumns.get(headerColumnIndex);
            double columnWidth = gridColumn.getWidth();
            if (!gridColumn.isVisible()) continue;
            List<GridColumn.HeaderMetaData> headerMetaData = gridColumn.getHeaderMetaData();
            double headerRowHeight = headerRowsHeight / (double)headerMetaData.size();
            for (int headerRowIndex = 0; headerRowIndex < headerMetaData.size(); ++headerRowIndex) {
                GridColumn.HeaderMetaData md = headerMetaData.get(headerRowIndex);
                if (!gridColumn.isMovable() || !(cy < (double)(headerRowIndex + 1) * headerRowHeight + headerMinY) || !(cx > floatingX + floatingWidth) || !(cx > offsetX) || !(cx < offsetX + columnWidth)) continue;
                List<GridColumn<?>> blockColumns = this.getBlockColumns(allColumns, headerMetaData, headerRowIndex, allColumns.indexOf(gridColumn));
                for (GridColumn<?> blockColumn : blockColumns) {
                    if (!floatingColumns.contains(blockColumn)) continue;
                    return;
                }
                this.state.setActiveGridWidget(view);
                this.state.setActiveGridColumns(blockColumns);
                this.state.setActiveHeaderMetaData(md);
                this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_MOVE_PENDING);
                this.setCursor(Style.Cursor.MOVE);
                return;
            }
            offsetX += columnWidth;
        }
    }

    private List<GridColumn<?>> getBlockColumns(List<GridColumn<?>> allColumns, List<GridColumn.HeaderMetaData> headerMetaData, int headerRowIndex, int headerColumnIndex) {
        int blockStartColumnIndex = this.getBlockStartColumnIndex(allColumns, headerMetaData.get(headerRowIndex), headerRowIndex, headerColumnIndex);
        int blockEndColumnIndex = this.getBlockEndColumnIndex(allColumns, headerMetaData.get(headerRowIndex), headerRowIndex, headerColumnIndex);
        ArrayList columns = new ArrayList();
        columns.addAll(allColumns.subList(blockStartColumnIndex, blockEndColumnIndex + 1));
        return columns;
    }

    private int getBlockStartColumnIndex(List<? extends GridColumn<?>> allColumns, GridColumn.HeaderMetaData headerMetaData, int headerRowIndex, int headerColumnIndex) {
        GridColumn<?> candidateColumn;
        List<GridColumn.HeaderMetaData> candidateHeaderMetaData;
        int candidateHeaderColumnIndex = headerColumnIndex;
        if (candidateHeaderColumnIndex == 0) {
            return candidateHeaderColumnIndex;
        }
        while (candidateHeaderColumnIndex > 0 && (candidateHeaderMetaData = (candidateColumn = allColumns.get(candidateHeaderColumnIndex - 1)).getHeaderMetaData()).size() - 1 >= headerRowIndex && candidateHeaderMetaData.get(headerRowIndex).equals(headerMetaData)) {
            --candidateHeaderColumnIndex;
        }
        return candidateHeaderColumnIndex;
    }

    private int getBlockEndColumnIndex(List<? extends GridColumn<?>> allColumns, GridColumn.HeaderMetaData headerMetaData, int headerRowIndex, int headerColumnIndex) {
        GridColumn<?> candidateColumn;
        List<GridColumn.HeaderMetaData> candidateHeaderMetaData;
        int candidateHeaderColumnIndex = headerColumnIndex;
        if (candidateHeaderColumnIndex == allColumns.size() - 1) {
            return candidateHeaderColumnIndex;
        }
        while (candidateHeaderColumnIndex < allColumns.size() - 1 && (candidateHeaderMetaData = (candidateColumn = allColumns.get(candidateHeaderColumnIndex + 1)).getHeaderMetaData()).size() - 1 >= headerRowIndex && candidateHeaderMetaData.get(headerRowIndex).equals(headerMetaData)) {
            ++candidateHeaderColumnIndex;
        }
        return candidateHeaderColumnIndex;
    }

    void findMovableRows(GridWidget view, double cx, double cy) {
        GridRow collapsedRow;
        if (!this.isOverRowDragHandleColumn(view, cx)) {
            return;
        }
        GridData gridModel = view.getModel();
        GridRenderer renderer = view.getRenderer();
        if (gridModel.getRowCount() == 0) {
            return;
        }
        int uiRowIndex = 0;
        double offsetY = cy - renderer.getHeaderHeight();
        while (true) {
            GridRow gridRow;
            GridRow row = gridModel.getRow(uiRowIndex);
            if (!(gridRow.getHeight() < offsetY)) break;
            offsetY -= row.getHeight();
            ++uiRowIndex;
        }
        if (uiRowIndex < 0 || uiRowIndex > gridModel.getRowCount() - 1) {
            return;
        }
        ArrayList<GridRow> rows = new ArrayList<GridRow>();
        rows.add(gridModel.getRow(uiRowIndex));
        while (uiRowIndex + 1 < gridModel.getRowCount() && (collapsedRow = gridModel.getRow(uiRowIndex + 1)).isCollapsed()) {
            rows.add(collapsedRow);
            ++uiRowIndex;
        }
        this.state.setActiveGridWidget(view);
        this.state.setActiveGridRows(rows);
        this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.ROW_MOVE_PENDING);
        this.setCursor(Style.Cursor.MOVE);
    }

    private boolean isOverRowDragHandleColumn(GridWidget view, double cx) {
        BaseGridRendererHelper rendererHelper = view.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return false;
        }
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> bodyColumns = bodyBlockInformation.getColumns();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        double bodyX = bodyBlockInformation.getX();
        double floatingX = floatingBlockInformation.getX();
        if (this.findRowDragHandleColumn(floatingColumns, floatingX, cx) != null) {
            return true;
        }
        return this.findRowDragHandleColumn(bodyColumns, bodyX, cx) != null;
    }

    private GridColumn<?> findRowDragHandleColumn(List<GridColumn<?>> columns, double offsetX, double cx) {
        double _offsetX = offsetX;
        for (GridColumn<?> gridColumn : columns) {
            if (!gridColumn.isVisible()) continue;
            if (gridColumn instanceof IsRowDragHandle) {
                double columnWidth = gridColumn.getWidth();
                if (cx > _offsetX && cx < _offsetX + columnWidth) {
                    return gridColumn;
                }
            }
            _offsetX += gridColumn.getWidth();
        }
        return null;
    }

    void handleColumnResize(NodeMouseMoveEvent event) {
        GridWidget activeGridWidget = this.state.getActiveGridWidget();
        List<GridColumn<?>> activeGridColumns = this.state.getActiveGridColumns();
        if (activeGridColumns.size() > 1) {
            return;
        }
        GridColumn<?> activeGridColumn = activeGridColumns.get(0);
        GridData activeGridModel = activeGridWidget.getModel();
        List<GridColumn<?>> allGridColumns = activeGridModel.getColumns();
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(activeGridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        double deltaX = ap.getX() - this.state.getEventInitialX();
        Double columnMinimumWidth = activeGridColumn.getMinimumWidth();
        Double columnMaximumWidth = activeGridColumn.getMaximumWidth();
        double columnNewWidth = this.state.getEventInitialColumnWidth() + deltaX;
        if (columnMinimumWidth != null && columnNewWidth < columnMinimumWidth) {
            columnNewWidth = columnMinimumWidth;
        }
        if (columnMaximumWidth != null && columnNewWidth > columnMaximumWidth) {
            columnNewWidth = columnMaximumWidth;
        }
        this.destroyColumns(allGridColumns);
        activeGridColumn.setWidth(columnNewWidth);
        this.layer.batch();
    }

    void handleColumnMove(NodeMouseMoveEvent event) {
        GridWidget activeGridWidget = this.state.getActiveGridWidget();
        List<GridColumn<?>> activeGridColumns = this.state.getActiveGridColumns();
        GridColumn.HeaderMetaData activeHeaderMetaData = this.state.getActiveHeaderMetaData();
        GridData activeGridModel = activeGridWidget.getModel();
        List<GridColumn<?>> allGridColumns = activeGridModel.getColumns();
        BaseGridRendererHelper rendererHelper = activeGridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return;
        }
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(activeGridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        double cx = ap.getX();
        if (cx < floatingX + floatingWidth) {
            return;
        }
        double activeBlockWidth = this.getBlockWidth(allGridColumns, allGridColumns.indexOf(activeGridColumns.get(0)), allGridColumns.indexOf(activeGridColumns.get(activeGridColumns.size() - 1)));
        for (int headerColumnIndex = 0; headerColumnIndex < allGridColumns.size(); ++headerColumnIndex) {
            GridColumn<?> candidateGridColumn = allGridColumns.get(headerColumnIndex);
            if (!candidateGridColumn.isVisible() || activeGridColumns.contains(candidateGridColumn)) continue;
            for (int headerRowIndex = 0; headerRowIndex < candidateGridColumn.getHeaderMetaData().size(); ++headerRowIndex) {
                GridColumn.HeaderMetaData candidateHeaderMetaData = candidateGridColumn.getHeaderMetaData().get(headerRowIndex);
                if (!candidateHeaderMetaData.getColumnGroup().equals(activeHeaderMetaData.getColumnGroup())) continue;
                int candidateBlockStartColumnIndex = this.getBlockStartColumnIndex(allGridColumns, candidateHeaderMetaData, headerRowIndex, headerColumnIndex);
                int candidateBlockEndColumnIndex = this.getBlockEndColumnIndex(allGridColumns, candidateHeaderMetaData, headerRowIndex, headerColumnIndex);
                double candidateBlockOffset = rendererHelper.getColumnOffset(candidateBlockStartColumnIndex);
                double candidateBlockWidth = this.getBlockWidth(allGridColumns, candidateBlockStartColumnIndex, candidateBlockEndColumnIndex);
                double minColX = Math.max(candidateBlockOffset, candidateBlockOffset + (candidateBlockWidth - activeBlockWidth) / 2.0);
                double maxColX = Math.min(candidateBlockOffset + candidateBlockWidth, candidateBlockOffset + (candidateBlockWidth + activeBlockWidth) / 2.0);
                double midColX = candidateBlockOffset + candidateBlockWidth / 2.0;
                if (!(cx > minColX) || !(cx < maxColX)) continue;
                if (cx < midColX) {
                    this.destroyColumns(allGridColumns);
                    activeGridModel.moveColumnsTo(candidateBlockEndColumnIndex, activeGridColumns);
                    this.state.getEventColumnHighlight().setX(activeGridWidget.getX() + rendererHelper.getColumnOffset(activeGridColumns.get(0)));
                    this.layer.batch();
                    return;
                }
                this.destroyColumns(allGridColumns);
                activeGridModel.moveColumnsTo(candidateBlockStartColumnIndex, activeGridColumns);
                this.state.getEventColumnHighlight().setX(activeGridWidget.getX() + rendererHelper.getColumnOffset(activeGridColumns.get(0)));
                this.layer.batch();
                return;
            }
        }
    }

    private double getBlockWidth(List<? extends GridColumn> columns, int blockStartColumnIndex, int blockEndColumnIndex) {
        double blockWidth = 0.0;
        for (int blockColumnIndex = blockStartColumnIndex; blockColumnIndex <= blockEndColumnIndex; ++blockColumnIndex) {
            GridColumn column = columns.get(blockColumnIndex);
            if (!column.isVisible()) continue;
            blockWidth += column.getWidth();
        }
        return blockWidth;
    }

    void handleRowMove(NodeMouseMoveEvent event) {
        GridWidget activeGridWidget = this.state.getActiveGridWidget();
        List<GridRow> activeGridRows = this.state.getActiveGridRows();
        GridData activeGridModel = activeGridWidget.getModel();
        List<GridColumn<?>> allGridColumns = activeGridModel.getColumns();
        BaseGridRendererHelper rendererHelper = activeGridWidget.getRendererHelper();
        GridRenderer renderer = activeGridWidget.getRenderer();
        double headerHeight = renderer.getHeaderHeight();
        GridRow leadRow = activeGridRows.get(0);
        int leadRowIndex = activeGridModel.getRows().indexOf(leadRow);
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(activeGridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        double cy = ap.getY();
        if (cy < headerHeight || cy > activeGridWidget.getHeight()) {
            return;
        }
        int uiRowIndex = 0;
        double offsetY = cy - headerHeight;
        while (true) {
            GridRow gridRow;
            GridRow row = activeGridModel.getRow(uiRowIndex);
            if (!(gridRow.getHeight() < offsetY)) break;
            offsetY -= row.getHeight();
            ++uiRowIndex;
        }
        if (uiRowIndex < 0 || uiRowIndex > activeGridModel.getRowCount() - 1) {
            return;
        }
        if (uiRowIndex == leadRowIndex) {
            return;
        }
        if (uiRowIndex < activeGridModel.getRows().indexOf(leadRow) ? offsetY > activeGridModel.getRow(uiRowIndex).getHeight() / 2.0 : uiRowIndex > activeGridModel.getRows().indexOf(leadRow) && offsetY < activeGridModel.getRow(uiRowIndex).getHeight() / 2.0) {
            return;
        }
        this.destroyColumns(allGridColumns);
        activeGridModel.moveRowsTo(uiRowIndex, activeGridRows);
        double rowOffsetY = rendererHelper.getRowOffset(leadRow) + headerHeight;
        this.state.getEventColumnHighlight().setY(activeGridWidget.getY() + rowOffsetY);
        this.layer.batch();
    }

    private void destroyColumns(List<GridColumn<?>> columns) {
        for (GridColumn<?> column : columns) {
            if (!(column instanceof HasDOMElementResources)) continue;
            ((HasDOMElementResources)((Object)column)).destroyResources();
        }
    }
}

