/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;

public class DefaultGridWidgetCellSelectorMouseEventHandler
implements NodeMouseEventHandler {
    protected GridSelectionManager selectionManager;

    public DefaultGridWidgetCellSelectorMouseEventHandler(GridSelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    @Override
    public boolean onNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        boolean isHandled = false;
        if (uiHeaderRowIndex.isPresent() && uiHeaderColumnIndex.isPresent()) {
            isHandled = this.handleHeaderCell(gridWidget, relativeLocation, uiHeaderRowIndex.get(), uiHeaderColumnIndex.get(), event);
        }
        if (!isHandled && uiRowIndex.isPresent() && uiColumnIndex.isPresent()) {
            isHandled = this.handleBodyCell(gridWidget, relativeLocation, uiRowIndex.get(), uiColumnIndex.get(), event);
        }
        if (isHandled && !gridWidget.isSelected()) {
            this.selectionManager.select(gridWidget);
        }
        return isHandled;
    }

    @Override
    public boolean handleHeaderCell(GridWidget gridWidget, Point2D relativeLocation, int uiHeaderRowIndex, int uiHeaderColumnIndex, AbstractNodeMouseEvent event) {
        boolean isHandled = gridWidget.selectHeaderCell(relativeLocation, event.isShiftKeyDown(), event.isControlKeyDown());
        if (isHandled) {
            gridWidget.getLayer().batch();
        }
        return isHandled;
    }

    @Override
    public boolean handleBodyCell(GridWidget gridWidget, Point2D relativeLocation, int uiRowIndex, int uiColumnIndex, AbstractNodeMouseEvent event) {
        boolean isHandled = gridWidget.selectCell(relativeLocation, event.isShiftKeyDown(), event.isControlKeyDown());
        if (isHandled) {
            gridWidget.getLayer().batch();
        }
        return isHandled;
    }
}

