/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.util;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

public class GridHighlightHelper {
    private double paddingX = 0.0;
    private double paddingY = 0.0;
    private boolean isPinnedGrid = false;
    private final GridLienzoPanel gridPanel;
    private final GridWidget gridWidget;

    public GridHighlightHelper(GridLienzoPanel gridPanel, GridWidget gridWidget) {
        this.gridPanel = gridPanel;
        this.gridWidget = gridWidget;
    }

    public void highlight(int row, int column) {
        double rowOffset = this.calculateRowOffset(row);
        double columnOffset = this.calculateColumnOffset(column);
        double y = this.applyPinnedGridConstraints(rowOffset);
        double x = this.applyPinnedGridConstraints(columnOffset);
        this.select(row, column);
        this.moveCanvasTo(x, y);
    }

    public void clearSelections() {
        GridWidget gridWidget = this.getGridWidget();
        gridWidget.getModel().clearSelections();
        gridWidget.draw();
    }

    public GridHighlightHelper withPaddingX(double paddingX) {
        this.paddingX = paddingX;
        return this;
    }

    public GridHighlightHelper withPaddingY(double paddingY) {
        this.paddingY = paddingY;
        return this;
    }

    public GridHighlightHelper withPinnedGrid() {
        this.isPinnedGrid = true;
        return this;
    }

    private void select(int row, int column) {
        this.gridWidget.selectCell(row, column, false, false);
        this.gridWidget.draw();
    }

    void moveCanvasTo(double x, double y) {
        double deltaY = this.calculateDeltaY(y);
        double deltaX = this.calculateDeltaX(x);
        Transform newTransform = this.getTransform().copy().translate(deltaX, deltaY);
        this.getViewport().setTransform(newTransform);
        this.getDefaultGridLayer().batch();
        this.getGridPanel().refreshScrollPosition();
    }

    private double calculateDeltaY(double y) {
        double rawY = -(y - this.getPaddingY());
        Range yRange = new Range(this.getVisibleBounds().getY() + this.getPaddingY(), this.getVisibleBounds().getY() + this.getVisibleBounds().getHeight() - this.getPaddingY());
        if (yRange.contains(rawY)) {
            return 0.0;
        }
        return y - this.getTransform().getTranslateY() / this.getTransform().getScaleY();
    }

    private double calculateDeltaX(double x) {
        double rawX = -(x - this.getPaddingX());
        Range xRange = new Range(this.getVisibleBounds().getX() + this.getPaddingX(), this.getVisibleBounds().getX() + this.getVisibleBounds().getWidth() - this.getPaddingX());
        if (xRange.contains(rawX)) {
            return 0.0;
        }
        return x - this.getTransform().getTranslateX() / this.getTransform().getScaleX();
    }

    double calculateColumnOffset(int column) {
        double offset = this.getRendererHelper().getColumnOffset(column);
        double x = this.getGridWidget().getX() + offset;
        return -(x - this.getPaddingX());
    }

    double calculateRowOffset(int row) {
        double offset = this.getRendererHelper().getRowOffset(row);
        double y = this.getGridWidget().getY() + offset;
        return -(y - this.getPaddingY());
    }

    private BaseGridRendererHelper getRendererHelper() {
        return this.getGridWidget().getRendererHelper();
    }

    private double applyPinnedGridConstraints(double value) {
        if (this.isPinnedGrid && value > 0.0) {
            return 0.0;
        }
        return value;
    }

    private Bounds getVisibleBounds() {
        return this.getDefaultGridLayer().getVisibleBounds();
    }

    private Transform getTransform() {
        return this.getViewport().getTransform();
    }

    private Viewport getViewport() {
        return this.getDefaultGridLayer().getViewport();
    }

    private GridLienzoPanel getGridPanel() {
        return this.gridPanel;
    }

    private GridWidget getGridWidget() {
        return this.gridWidget;
    }

    double getPaddingX() {
        return this.paddingX;
    }

    double getPaddingY() {
        return this.paddingY;
    }

    private DefaultGridLayer getDefaultGridLayer() {
        return this.getGridPanel().getDefaultGridLayer();
    }

    class Range {
        final double min;
        final double max;

        Range(double min, double max) {
            this.min = min;
            this.max = max;
        }

        boolean contains(double value) {
            return value > this.min && value < this.max;
        }
    }
}

