/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.animation;

import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.animation.IAnimation;
import com.ait.lienzo.client.core.animation.IAnimationCallback;
import com.ait.lienzo.client.core.animation.IAnimationHandle;
import com.ait.lienzo.client.core.animation.TimedAnimation;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class MergableGridWidgetCollapseRowsAnimation
extends TimedAnimation {
    public MergableGridWidgetCollapseRowsAnimation(final GridWidget gridWidget, final int uiRowIndex, final int uiColumnIndex, final int rowCount) {
        super(500.0, new IAnimationCallback(){
            private AnimationTweener tweener = AnimationTweener.EASE_OUT;

            public void onStart(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                gridWidget.getModel().collapseCell(uiRowIndex, uiColumnIndex);
            }

            public void onFrame(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
                double pct = this.assertPct(iAnimation.getPercent());
                for (int i = 1; i < rowCount; ++i) {
                    GridRow row = gridWidget.getModel().getRow(uiRowIndex + i);
                    row.setHeight((1.0 - pct) * row.peekHeight());
                }
                gridWidget.getLayer().batch();
            }

            public void onClose(IAnimation iAnimation, IAnimationHandle iAnimationHandle) {
            }

            private double assertPct(double pct) {
                if (pct < 0.0) {
                    return 0.0;
                }
                if (pct > 1.0) {
                    return 1.0;
                }
                return this.tweener.apply(pct);
            }
        });
    }
}

