/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl;

import com.ait.lienzo.client.core.shape.BoundingBoxPathClipper;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPathClipper;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import java.util.List;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.GroupingToggle;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public class ColumnRenderingStrategyMerged {
    public Group render(GridColumn<?> column, GridBodyColumnRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        double absoluteGridY = context.getAbsoluteGridY();
        double absoluteColumnX = context.getAbsoluteColumnX();
        double clipMinY = context.getClipMinY();
        double clipMinX = context.getClipMinX();
        int minVisibleRowIndex = context.getMinVisibleRowIndex();
        int maxVisibleRowIndex = context.getMaxVisibleRowIndex();
        List<Double> visibleRowOffsets = renderingInformation.getVisibleRowOffsets();
        boolean isFloating = context.isFloating();
        GridData model = context.getModel();
        Transform transform = context.getTransform();
        GridRenderer renderer = context.getRenderer();
        GridRendererTheme theme = renderer.getTheme();
        Group g = new Group();
        double columnWidth = column.getWidth();
        double columnHeight = visibleRowOffsets.get(maxVisibleRowIndex - minVisibleRowIndex) - visibleRowOffsets.get(0) + model.getRow(maxVisibleRowIndex).getHeight();
        MultiPath bodyGrid = theme.getBodyGridLine();
        for (int rowIndex = minVisibleRowIndex; rowIndex <= maxVisibleRowIndex; ++rowIndex) {
            double y = visibleRowOffsets.get(rowIndex - minVisibleRowIndex) - visibleRowOffsets.get(0);
            GridRow row = model.getRow(rowIndex);
            if (!row.isMerged()) {
                bodyGrid.M(0.0, y + 0.5).L(columnWidth, y + 0.5);
                continue;
            }
            if (row.isCollapsed()) continue;
            int columnIndex = model.getColumns().indexOf(column);
            GridCell<?> cell = model.getCell(rowIndex, columnIndex);
            if (cell == null || cell.getMergedCellCount() > 0) {
                bodyGrid.M(0.0, y + 0.5).L(columnWidth, y + 0.5);
                continue;
            }
            if (!this.isCollapsedRowMultiValue(model, column, cell, rowIndex)) continue;
            bodyGrid.M(0.0, y + 0.5).L(columnWidth, y + 0.5);
        }
        int columnIndex = model.getColumns().indexOf(column);
        if (columnIndex < model.getColumnCount() - 1) {
            bodyGrid.M(columnWidth + 0.5, 0.0).L(columnWidth + 0.5, columnHeight);
        }
        Group columnGroup = new Group();
        int iterations = 0;
        for (int rowIndex = minVisibleRowIndex; rowIndex <= maxVisibleRowIndex && ++iterations <= 1000; ++rowIndex) {
            GridCell<?> nextRowCell;
            double y = visibleRowOffsets.get(rowIndex - minVisibleRowIndex) - visibleRowOffsets.get(0);
            GridRow row = model.getRow(rowIndex);
            GridCell<?> cell = model.getCell(rowIndex, columnIndex);
            if (row.isCollapsed()) continue;
            boolean isCollapsedCellMixedValue = this.isCollapsedCellMixedValue(model, rowIndex, columnIndex);
            if (isCollapsedCellMixedValue) {
                Group mixedValueGroup = this.renderMergedCellMixedValueHighlight(columnWidth, row.getHeight());
                ((Group)((Group)mixedValueGroup.setX(0.0)).setY(y)).setListening(true);
                g.add((IPrimitive)mixedValueGroup);
            }
            if (cell == null) continue;
            if (cell.getMergedCellCount() > 1 && (nextRowCell = model.getCell(rowIndex + 1, columnIndex)) != null) {
                Group gt = this.renderGroupedCellToggle(columnWidth, row.getHeight(), nextRowCell.isCollapsed());
                ((Group)gt.setX(0.0)).setY(y);
                g.add((IPrimitive)gt);
            }
            if (cell.getMergedCellCount() > 0) {
                double cellHeight = this.getCellHeight(rowIndex, model, cell);
                GridBodyCellRenderContext cellContext = new GridBodyCellRenderContext(absoluteColumnX, absoluteGridY + renderer.getHeaderHeight() + visibleRowOffsets.get(rowIndex - minVisibleRowIndex), columnWidth, cellHeight, clipMinY, clipMinX, rowIndex, columnIndex, isFloating, transform, renderer);
                Group cc = column.getColumnRenderer().renderCell(cell, cellContext);
                ((Group)((Group)cc.setX(0.0)).setY(y)).setListening(true);
                columnGroup.add((IPrimitive)cc);
                rowIndex = rowIndex + cell.getMergedCellCount() - 1;
                continue;
            }
            double _y = y;
            int _rowIndex = rowIndex;
            GridCell<?> _cell = cell;
            while (_cell.getMergedCellCount() == 0) {
                _y -= model.getRow(--_rowIndex).getHeight();
                _cell = model.getCell(_rowIndex, columnIndex);
            }
            double cellHeight = this.getCellHeight(_rowIndex, model, _cell);
            GridBodyCellRenderContext cellContext = new GridBodyCellRenderContext(absoluteColumnX, absoluteGridY + renderer.getHeaderHeight() + rendererHelper.getRowOffset(_rowIndex), columnWidth, cellHeight, clipMinY, clipMinX, rowIndex, columnIndex, isFloating, transform, renderer);
            Group cc = column.getColumnRenderer().renderCell(_cell, cellContext);
            ((Group)((Group)cc.setX(0.0)).setY(_y)).setListening(true);
            columnGroup.add((IPrimitive)cc);
            rowIndex = _rowIndex + _cell.getMergedCellCount() - 1;
        }
        double gridLinesStrokeWidth = theme.getBodyGridLine().getStrokeWidth();
        BoundingBox bb = new BoundingBox(gridLinesStrokeWidth, 0.0, columnWidth - gridLinesStrokeWidth, columnHeight);
        BoundingBoxPathClipper clipper = new BoundingBoxPathClipper(bb);
        columnGroup.setPathClipper((IPathClipper)clipper);
        clipper.setActive(true);
        g.add((IPrimitive)columnGroup);
        g.add((IPrimitive)bodyGrid);
        return g;
    }

    private boolean isCollapsedRowMultiValue(GridData model, GridColumn<?> column, GridCell<?> cell, int rowIndex) {
        GridCell<?> nc;
        GridRow row;
        int rowOffset = 1;
        int columnIndex = column.getIndex();
        while ((row = model.getRow(rowIndex - rowOffset)).isCollapsed()) {
            nc = row.getCells().get(columnIndex);
            if (nc == null) {
                return true;
            }
            if (!cell.getValue().equals(nc.getValue())) {
                return true;
            }
            ++rowOffset;
        }
        nc = row.getCells().get(columnIndex);
        if (nc == null) {
            return true;
        }
        return !cell.getValue().equals(nc.getValue());
    }

    private boolean isCollapsedCellMixedValue(GridData model, int rowIndex, int columnIndex) {
        int _rowIndex = rowIndex;
        GridCell<?> currentCell = model.getCell(_rowIndex, columnIndex);
        if (currentCell != null) {
            while (_rowIndex > 0 && currentCell.getMergedCellCount() == 0) {
                currentCell = model.getCell(--_rowIndex, columnIndex);
            }
        }
        if (++_rowIndex > model.getRowCount() - 1) {
            return false;
        }
        while (_rowIndex < model.getRowCount() && model.getRow(_rowIndex).isCollapsed()) {
            GridCell<?> nextCell = model.getCell(_rowIndex, columnIndex);
            if (currentCell == null) {
                if (nextCell != null) {
                    return true;
                }
            } else {
                if (nextCell == null) {
                    return true;
                }
                if (!currentCell.getValue().getValue().equals(nextCell.getValue().getValue())) {
                    return true;
                }
            }
            ++_rowIndex;
        }
        return false;
    }

    private double getCellHeight(int rowIndex, GridData model, GridCell<?> cell) {
        double height = 0.0;
        for (int i = rowIndex; i < rowIndex + cell.getMergedCellCount(); ++i) {
            height += model.getRow(i).getHeight();
        }
        return height;
    }

    private Group renderGroupedCellToggle(double cellWidth, double cellHeight, boolean isCollapsed) {
        return new GroupingToggle(cellWidth, cellHeight, isCollapsed);
    }

    private Group renderMergedCellMixedValueHighlight(double cellWidth, double cellHeight) {
        Group g = new Group();
        Rectangle multiValueHighlight = new Rectangle(cellWidth, cellHeight);
        multiValueHighlight.setFillColor((IColor)ColorName.GOLDENROD);
        g.add((IPrimitive)multiValueHighlight);
        return g;
    }
}

