/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickHandler;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.GroupOf;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.stream.Stream;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBoundaryRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.dom.multiple.HasMultipleDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetMouseClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetMouseDoubleClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.GridCellSelectorMouseClickHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.SelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.DefaultSelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.FloatingSelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.BaseCellSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class BaseGridWidget
extends Group
implements GridWidget {
    protected final SelectionsTransformer bodyTransformer;
    protected final SelectionsTransformer floatingColumnsTransformer;
    protected final BaseGridRendererHelper rendererHelper;
    protected final Queue<Pair<Group, List<GridRenderer.RendererCommand>>> renderQueue = new ArrayDeque<Pair<Group, List<GridRenderer.RendererCommand>>>();
    protected final List<GridColumn<?>> allColumns = new ArrayList();
    protected final List<GridColumn<?>> bodyColumns = new ArrayList();
    protected final List<GridColumn<?>> floatingColumns = new ArrayList();
    protected GridData model;
    protected GridRenderer renderer;
    protected Group header = null;
    protected Group floatingHeader = null;
    protected Group body = null;
    protected Group bodySelections = null;
    protected Group floatingBody = null;
    protected Group floatingBodySelections = null;
    protected Group boundary = null;
    protected BaseGridRendererHelper.RenderingInformation renderingInformation;
    private Group selection = null;
    private boolean isSelected = false;
    private final CellSelectionManager cellSelectionManager;

    public BaseGridWidget(GridData model, GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager, GridRenderer renderer) {
        this.model = model;
        this.renderer = renderer;
        this.bodyTransformer = new DefaultSelectionsTransformer(model, this.bodyColumns);
        this.floatingColumnsTransformer = new FloatingSelectionsTransformer(model, this.floatingColumns);
        this.rendererHelper = this.getBaseGridRendererHelper();
        this.cellSelectionManager = this.getCellSelectionManager();
        this.addNodeMouseClickHandler(this.getGridMouseClickHandler(selectionManager));
        this.addNodeMouseClickHandler(this.getGridMouseCellSelectorClickHandler(selectionManager));
        this.addNodeMouseDoubleClickHandler(this.getGridMouseDoubleClickHandler(selectionManager, pinnedModeManager));
        this.addNodeDragEndHandler(event -> {
            GridWidgetDnDHandlersState state = ((DefaultGridLayer)this.getLayer()).getGridWidgetHandlersState();
            state.reset();
            this.getViewport().getElement().getStyle().setCursor(state.getCursor());
        });
    }

    protected BaseGridRendererHelper getBaseGridRendererHelper() {
        return new BaseGridRendererHelper(this);
    }

    protected CellSelectionManager getCellSelectionManager() {
        return new BaseCellSelectionManager(this);
    }

    protected NodeMouseClickHandler getGridMouseClickHandler(GridSelectionManager selectionManager) {
        return new BaseGridWidgetMouseClickHandler(this, selectionManager, this.renderer);
    }

    protected NodeMouseClickHandler getGridMouseCellSelectorClickHandler(GridSelectionManager selectionManager) {
        return new GridCellSelectorMouseClickHandler(this, selectionManager, this.renderer);
    }

    protected NodeMouseDoubleClickHandler getGridMouseDoubleClickHandler(GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager) {
        return new BaseGridWidgetMouseDoubleClickHandler(this, selectionManager, pinnedModeManager, this.renderer);
    }

    @Override
    public GridData getModel() {
        return this.model;
    }

    @Override
    public GridRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void setRenderer(GridRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public BaseGridRendererHelper getRendererHelper() {
        return this.rendererHelper;
    }

    @Override
    public Group getBody() {
        return this.body;
    }

    @Override
    public Group getHeader() {
        return this.header;
    }

    @Override
    public double getWidth() {
        return this.rendererHelper.getWidth(this.model.getColumns());
    }

    @Override
    public double getHeight() {
        double height = this.renderer.getHeaderHeight();
        return height += this.rendererHelper.getRowOffset(this.model.getRowCount());
    }

    @Override
    public double getAbsoluteX() {
        double x = this.getX();
        for (Node parent = this.getParent(); parent != null && !(parent instanceof Layer); parent = parent.getParent()) {
            if (!(parent instanceof GroupOf)) continue;
            x += ((GroupOf)parent).getX();
        }
        return x;
    }

    @Override
    public double getAbsoluteY() {
        double y = this.getY();
        for (Node parent = this.getParent(); parent != null && !(parent instanceof Layer); parent = parent.getParent()) {
            if (!(parent instanceof GroupOf)) continue;
            y += ((GroupOf)parent).getY();
        }
        return y;
    }

    @Override
    public void select() {
        this.isSelected = true;
        if (this.renderingInformation == null) {
            return;
        }
        this.assertSelectionWidget();
        this.add((IPrimitive)this.selection);
    }

    @Override
    public void deselect() {
        this.isSelected = false;
        if (this.selection != null) {
            this.remove((IPrimitive)this.selection);
        }
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    private void assertSelectionWidget() {
        this.selection = new Group();
        this.addCommandToRenderQueue(this.selection, this.renderer.renderSelector(this.getWidth(), this.getHeight(), this.renderingInformation));
    }

    protected void drawWithoutTransforms(Context2D context, double alpha, BoundingBox bb) {
        boolean isSelectionLayer = context.isSelection();
        if (isSelectionLayer && !this.isListening()) {
            return;
        }
        if ((alpha *= this.getAttributes().getAlpha()) <= 0.0) {
            return;
        }
        if (this.model.getColumns().isEmpty()) {
            return;
        }
        this.removeAll();
        if (!isSelectionLayer) {
            this.renderingInformation = this.prepare();
            if (this.renderingInformation == null) {
                this.destroyDOMElementResources();
                return;
            }
            this.makeRenderingCommands();
        }
        this.layerRenderGroups();
        this.executeRenderQueueCommands(isSelectionLayer);
        if (!isSelectionLayer) {
            Stream.concat(this.bodyColumns.stream(), this.floatingColumns.stream()).filter(column -> column instanceof HasMultipleDOMElementResources).map(column -> (HasMultipleDOMElementResources)((Object)column)).forEach(HasMultipleDOMElementResources::freeUnusedResources);
        }
        super.drawWithoutTransforms(context, alpha, bb);
    }

    private BaseGridRendererHelper.RenderingInformation prepare() {
        this.body = null;
        this.header = null;
        this.floatingBody = null;
        this.floatingHeader = null;
        this.bodySelections = null;
        this.floatingBodySelections = null;
        this.boundary = null;
        this.allColumns.clear();
        this.bodyColumns.clear();
        this.floatingColumns.clear();
        this.renderQueue.clear();
        BaseGridRendererHelper.RenderingInformation renderingInformation = this.rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return null;
        }
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> allColumns = renderingInformation.getAllColumns();
        List<GridColumn<?>> bodyColumns = bodyBlockInformation.getColumns();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        this.allColumns.addAll(allColumns);
        this.bodyColumns.addAll(bodyColumns);
        this.floatingColumns.addAll(floatingColumns);
        return renderingInformation;
    }

    private void destroyDOMElementResources() {
        for (GridColumn<?> column : this.model.getColumns()) {
            if (!(column.getColumnRenderer() instanceof HasDOMElementResources)) continue;
            ((HasDOMElementResources)((Object)column.getColumnRenderer())).destroyResources();
        }
    }

    private void makeRenderingCommands() {
        for (GridColumn<?> column : this.model.getColumns()) {
            if (this.bodyColumns.contains(column) || this.floatingColumns.contains(column)) {
                if (!(column instanceof HasMultipleDOMElementResources)) continue;
                ((HasMultipleDOMElementResources)((Object)column)).initialiseResources();
                continue;
            }
            if (!(column instanceof HasDOMElementResources)) continue;
            ((HasDOMElementResources)((Object)column)).destroyResources();
        }
        if (this.bodyColumns.size() > 0) {
            this.boundary = new Group();
            this.drawHeader(this.renderingInformation);
            if (this.model.getRowCount() > 0) {
                this.drawBody(this.renderingInformation);
            }
        }
        int minVisibleRowIndex = this.renderingInformation.getMinVisibleRowIndex();
        int maxVisibleRowIndex = this.renderingInformation.getMaxVisibleRowIndex();
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = this.renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = this.renderingInformation.getFloatingBlockInformation();
        if (this.bodySelections != null) {
            this.addCommandToRenderQueue(this.bodySelections, this.renderSelectedRanges(this.bodyColumns, bodyBlockInformation.getX(), minVisibleRowIndex, maxVisibleRowIndex, this.bodyTransformer, this.renderingInformation));
        }
        if (this.floatingBodySelections != null) {
            this.addCommandToRenderQueue(this.floatingBodySelections, this.renderSelectedRanges(this.floatingColumns, floatingBlockInformation.getX(), minVisibleRowIndex, maxVisibleRowIndex, this.floatingColumnsTransformer, this.renderingInformation));
        }
        if (this.boundary != null) {
            this.addCommandToRenderQueue(this.boundary, this.renderGridBoundary(this.renderingInformation));
        }
        if (this.isSelected) {
            this.assertSelectionWidget();
        }
    }

    private void layerRenderGroups() {
        if (this.body != null) {
            this.add((IPrimitive)this.body);
        }
        if (this.bodySelections != null) {
            this.add((IPrimitive)this.bodySelections);
        }
        if (this.header != null) {
            this.add((IPrimitive)this.header);
        }
        if (this.floatingBody != null) {
            this.add((IPrimitive)this.floatingBody);
        }
        if (this.floatingBodySelections != null) {
            this.add((IPrimitive)this.floatingBodySelections);
        }
        if (this.floatingHeader != null) {
            this.add((IPrimitive)this.floatingHeader);
        }
        if (this.boundary != null) {
            this.add((IPrimitive)this.boundary);
        }
        if (this.isSelected) {
            this.add((IPrimitive)this.selection);
        }
    }

    public Group setVisible(boolean visible) {
        if (!visible) {
            for (GridColumn<?> gc : this.getModel().getColumns()) {
                if (!(gc instanceof HasMultipleDOMElementResources)) continue;
                ((HasMultipleDOMElementResources)((Object)gc)).destroyResources();
            }
        }
        return (Group)super.setVisible(visible);
    }

    protected void drawHeader(BaseGridRendererHelper.RenderingInformation renderingInformation) {
        List<GridColumn<?>> allColumns = renderingInformation.getAllColumns();
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double headerX = bodyBlockInformation.getX();
        double headerY = bodyBlockInformation.getHeaderY();
        double floatingHeaderX = floatingBlockInformation.getX();
        double floatingHeaderY = floatingBlockInformation.getHeaderY();
        boolean addFixedHeader = renderingInformation.isFixedHeader();
        boolean addFloatingHeader = renderingInformation.isFloatingHeader();
        if (addFixedHeader || addFloatingHeader) {
            if (this.bodyColumns.size() > 0) {
                this.header = new Group();
                this.header.setX(headerX);
                this.addCommandsToRenderQueue(this.header, this.renderGridHeaderWidget(allColumns, this.bodyColumns, renderingInformation));
                if (addFloatingHeader) {
                    this.header.setY(headerY);
                }
            }
            if (this.floatingColumns.size() > 0) {
                this.floatingHeader = new Group();
                ((Group)this.floatingHeader.setX(floatingHeaderX)).setY(floatingHeaderY);
                this.addCommandsToRenderQueue(this.floatingHeader, this.renderGridHeaderWidget(this.floatingColumns, this.floatingColumns, renderingInformation));
            }
        }
    }

    protected void drawBody(BaseGridRendererHelper.RenderingInformation renderingInformation) {
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double bodyX = bodyBlockInformation.getX();
        double bodyY = bodyBlockInformation.getBodyY();
        double floatingBodyX = floatingBlockInformation.getX();
        double floatingBodyY = floatingBlockInformation.getBodyY();
        int minVisibleRowIndex = renderingInformation.getMinVisibleRowIndex();
        int maxVisibleRowIndex = renderingInformation.getMaxVisibleRowIndex();
        if (this.bodyColumns.size() > 0) {
            this.body = new Group();
            ((Group)this.body.setX(bodyX)).setY(bodyY);
            this.bodySelections = new Group();
            ((Group)this.bodySelections.setX(bodyX)).setY(bodyY);
            this.addCommandsToRenderQueue(this.body, this.renderGridBodyWidget(this.bodyColumns, bodyBlockInformation.getX(), minVisibleRowIndex, maxVisibleRowIndex, this.bodyTransformer, renderingInformation));
        }
        if (this.floatingColumns.size() > 0) {
            this.floatingBody = new Group();
            ((Group)this.floatingBody.setX(floatingBodyX)).setY(floatingBodyY);
            this.floatingBodySelections = new Group();
            ((Group)this.floatingBodySelections.setX(floatingBodyX)).setY(floatingBodyY);
            this.addCommandsToRenderQueue(this.floatingBody, this.renderGridBodyWidget(this.floatingColumns, floatingBlockInformation.getX(), minVisibleRowIndex, maxVisibleRowIndex, this.floatingColumnsTransformer, renderingInformation));
        }
    }

    protected void addCommandToRenderQueue(Group parent, GridRenderer.RendererCommand command) {
        this.addCommandsToRenderQueue(parent, Collections.singletonList(command));
    }

    protected void addCommandsToRenderQueue(Group parent, List<GridRenderer.RendererCommand> commands) {
        this.renderQueue.add((Pair<Group, List<GridRenderer.RendererCommand>>)new Pair((Object)parent, commands));
    }

    protected void executeRenderQueueCommands(boolean isSelectionLayer) {
        this.renderQueue.stream().forEach(p -> ((List)p.getK2()).forEach(c -> c.execute(new GridRenderer.GridRendererContext((Pair)p, isSelectionLayer){
            final /* synthetic */ Pair val$p;
            final /* synthetic */ boolean val$isSelectionLayer;
            {
                this.val$p = pair;
                this.val$isSelectionLayer = bl;
            }

            @Override
            public Group getGroup() {
                return (Group)this.val$p.getK1();
            }

            @Override
            public boolean isSelectionLayer() {
                return this.val$isSelectionLayer;
            }
        })));
    }

    protected List<GridRenderer.RendererCommand> renderGridHeaderWidget(List<GridColumn<?>> allColumns, List<GridColumn<?>> blockColumns, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        GridHeaderRenderContext context = new GridHeaderRenderContext(allColumns, blockColumns);
        return this.renderer.renderHeader(this.model, context, this.rendererHelper, renderingInformation);
    }

    protected List<GridRenderer.RendererCommand> renderGridBodyWidget(List<GridColumn<?>> blockColumns, double absoluteColumnOffsetX, int minVisibleRowIndex, int maxVisibleRowIndex, SelectionsTransformer transformer, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double clipMinY = this.getAbsoluteY() + (this.header == null ? 0.0 : this.header.getY() + this.getRenderer().getHeaderHeight());
        double clipMinX = this.getAbsoluteX() + floatingX + floatingWidth;
        GridBodyRenderContext context = new GridBodyRenderContext(this.getAbsoluteX(), this.getAbsoluteY(), absoluteColumnOffsetX, clipMinY, clipMinX, minVisibleRowIndex, maxVisibleRowIndex, blockColumns, this.getViewport().getTransform(), this.renderer, transformer);
        return this.renderer.renderBody(this.model, context, this.rendererHelper, renderingInformation);
    }

    protected GridRenderer.RendererCommand renderGridBoundary(BaseGridRendererHelper.RenderingInformation renderingInformation) {
        double x = 0.0;
        ArrayList allColumns = new ArrayList();
        BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        if (this.body != null || this.header != null) {
            allColumns.addAll(this.bodyColumns);
            x = bodyBlockInformation.getX();
        }
        if (this.floatingBody != null || this.floatingHeader != null) {
            allColumns.addAll(this.floatingColumns);
            x = floatingBlockInformation.getX();
        }
        double headerYOffset = this.header == null ? 0.0 : this.header.getY();
        double headerRowsYOffset = renderingInformation.getHeaderRowsYOffset();
        double y = headerRowsYOffset + headerYOffset;
        double height = this.getHeight() - headerRowsYOffset - headerYOffset;
        double width = this.rendererHelper.getWidth(allColumns);
        if (!this.floatingColumns.isEmpty()) {
            width -= floatingBlockInformation.getX() + this.rendererHelper.getWidth(this.floatingColumns) - bodyBlockInformation.getX();
        }
        GridBoundaryRenderContext context = new GridBoundaryRenderContext(x, y, width, height);
        return this.renderer.renderGridBoundary(context);
    }

    protected GridRenderer.RendererCommand renderSelectedRanges(List<GridColumn<?>> blockColumns, double absoluteColumnOffsetX, int minVisibleRowIndex, int maxVisibleRowIndex, SelectionsTransformer transformer, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double clipMinY = this.getAbsoluteY() + (this.header == null ? 0.0 : this.header.getY() + this.getRenderer().getHeaderHeight());
        double clipMinX = this.getAbsoluteX() + floatingX + floatingWidth;
        GridBodyRenderContext context = new GridBodyRenderContext(this.getAbsoluteX(), this.getAbsoluteY(), absoluteColumnOffsetX, clipMinY, clipMinX, minVisibleRowIndex, maxVisibleRowIndex, blockColumns, this.getViewport().getTransform(), this.renderer, transformer);
        return this.renderer.renderSelectedCells(this.model, context, this.rendererHelper);
    }

    public void onNodeMouseClick(NodeMouseClickEvent event) {
        this.fireEvent((GwtEvent)event);
    }

    @Override
    public boolean onGroupingToggle(double cellX, double cellY, double cellWidth, double cellHeight) {
        return this.renderer.onGroupingToggle(cellX, cellY, cellWidth, cellHeight);
    }

    @Override
    public boolean selectCell(Point2D ap, boolean isShiftKeyDown, boolean isControlKeyDown) {
        return this.cellSelectionManager.selectCell(ap, isShiftKeyDown, isControlKeyDown);
    }

    @Override
    public boolean selectCell(int uiRowIndex, int uiColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        return this.cellSelectionManager.selectCell(uiRowIndex, uiColumnIndex, isShiftKeyDown, isControlKeyDown);
    }

    @Override
    public boolean adjustSelection(SelectionExtension direction, boolean isShiftKeyDown) {
        return this.cellSelectionManager.adjustSelection(direction, isShiftKeyDown);
    }

    @Override
    public boolean startEditingCell(int uiRowIndex, int uiColumnIndex) {
        return this.cellSelectionManager.startEditingCell(uiRowIndex, uiColumnIndex);
    }

    @Override
    public boolean startEditingCell(Point2D rp) {
        return this.cellSelectionManager.startEditingCell(rp);
    }
}

