/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class BaseGridWidgetMouseDoubleClickHandler
implements NodeMouseDoubleClickHandler {
    protected GridData gridModel;
    protected GridWidget gridWidget;
    protected BaseGridRendererHelper rendererHelper;
    protected GridSelectionManager selectionManager;
    protected GridPinnedModeManager pinnedModeManager;
    protected GridRenderer renderer;

    public BaseGridWidgetMouseDoubleClickHandler(GridWidget gridWidget, GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager, GridRenderer renderer) {
        this.gridWidget = gridWidget;
        this.gridModel = gridWidget.getModel();
        this.rendererHelper = gridWidget.getRendererHelper();
        this.selectionManager = selectionManager;
        this.pinnedModeManager = pinnedModeManager;
        this.renderer = renderer;
    }

    public void onNodeMouseDoubleClick(NodeMouseDoubleClickEvent event) {
        if (!this.gridWidget.isVisible()) {
            return;
        }
        if (!this.handleHeaderCellDoubleClick(event)) {
            this.handleBodyCellDoubleClick(event);
        }
    }

    protected boolean handleHeaderCellDoubleClick(NodeMouseDoubleClickEvent event) {
        double headerMaxY;
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        double cx = ap.getX();
        double cy = ap.getY();
        Group header = this.gridWidget.getHeader();
        double headerRowsYOffset = this.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        double d = headerMaxY = header == null ? this.renderer.getHeaderHeight() : this.renderer.getHeaderHeight() + header.getY();
        if (cx < 0.0 || cx > this.gridWidget.getWidth()) {
            return false;
        }
        if (cy < headerMinY || cy > headerMaxY) {
            return false;
        }
        if (!this.pinnedModeManager.isGridPinned()) {
            this.pinnedModeManager.enterPinnedMode(this.gridWidget, () -> {});
        } else {
            this.pinnedModeManager.exitPinnedMode(() -> {});
        }
        return true;
    }

    protected double getHeaderRowsYOffset() {
        GridData model = this.gridWidget.getModel();
        int headerRowCount = model.getHeaderRowCount();
        double headerHeight = this.renderer.getHeaderHeight();
        double headerRowHeight = this.renderer.getHeaderRowHeight();
        double headerRowsHeight = headerRowHeight * (double)headerRowCount;
        double headerRowsYOffset = headerHeight - headerRowsHeight;
        return headerRowsYOffset;
    }

    protected boolean handleBodyCellDoubleClick(NodeMouseDoubleClickEvent event) {
        Point2D rp = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        return this.gridWidget.startEditingCell(rp);
    }
}

