/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Line;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Point2DArray;
import com.ait.lienzo.client.core.types.Transform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBoundaryRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.SelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.GroupingToggle;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.SelectedRange;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public class BaseGridRenderer
implements GridRenderer {
    private static final int HEADER_HEIGHT = 64;
    private static final int HEADER_ROW_HEIGHT = 32;
    private static final String LINK_FONT_FAMILY = "Glyphicons Halflings";
    private static final double LINK_FONT_SIZE = 10.0;
    private static final String LINK_ICON = "\ue144";
    protected GridRendererTheme theme;
    protected BiFunction<Boolean, GridColumn<?>, Boolean> columnRenderingConstraint = (isSelectionLayer, gridColumn) -> isSelectionLayer == false;

    public BaseGridRenderer(GridRendererTheme theme) {
        this.setTheme(theme);
    }

    @Override
    public double getHeaderHeight() {
        return 64.0;
    }

    @Override
    public double getHeaderRowHeight() {
        return 32.0;
    }

    @Override
    public GridRendererTheme getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(GridRendererTheme theme) {
        this.theme = (GridRendererTheme)PortablePreconditions.checkNotNull((String)"theme", (Object)theme);
    }

    @Override
    public GridRenderer.RendererCommand renderSelector(double width, double height, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        return rc -> {
            if (!rc.isSelectionLayer()) {
                MultiPath selector = (MultiPath)this.theme.getSelector().M(0.5, 0.5).L(0.5, height).L(width, height).L(width, 0.5).L(0.5, 0.5).setListening(false);
                rc.getGroup().add((IPrimitive)selector);
            }
        };
    }

    @Override
    public GridRenderer.RendererCommand renderSelectedCells(GridData model, GridBodyRenderContext context, BaseGridRendererHelper rendererHelper) {
        return rc -> {
            if (!rc.isSelectionLayer()) {
                List<GridColumn<?>> blockColumns = context.getBlockColumns();
                SelectionsTransformer transformer = context.getTransformer();
                double gridLineStrokeWidth = this.theme.getBodyGridLine().getStrokeWidth();
                double selectorStrokeWidth = this.theme.getCellSelectorBorder().getStrokeWidth();
                int minVisibleUiColumnIndex = model.getColumns().indexOf(blockColumns.get(0));
                int maxVisibleUiColumnIndex = model.getColumns().indexOf(blockColumns.get(blockColumns.size() - 1));
                int minVisibleUiRowIndex = context.getMinVisibleRowIndex();
                int maxVisibleUiRowIndex = context.getMaxVisibleRowIndex();
                List<SelectedRange> selectedRanges = transformer.transformToSelectedRanges();
                Group g = new Group();
                for (SelectedRange selectedRange : selectedRanges) {
                    Group cs;
                    int rangeOriginUiColumnIndex = selectedRange.getUiColumnIndex();
                    int rangeOriginUiRowIndex = selectedRange.getUiRowIndex();
                    int rangeUiWidth = selectedRange.getWidth();
                    int rangeUiHeight = selectedRange.getHeight();
                    if (rangeOriginUiColumnIndex + rangeUiWidth - 1 < minVisibleUiColumnIndex || rangeOriginUiColumnIndex > maxVisibleUiColumnIndex || rangeOriginUiRowIndex + rangeUiHeight - 1 < minVisibleUiRowIndex || rangeOriginUiRowIndex > maxVisibleUiRowIndex) continue;
                    SelectedRange _selectedRange = selectedRange;
                    if (rangeOriginUiRowIndex < minVisibleUiRowIndex) {
                        int dy = minVisibleUiRowIndex - rangeOriginUiRowIndex;
                        _selectedRange = new SelectedRange(selectedRange.getUiRowIndex() + dy, selectedRange.getUiColumnIndex(), selectedRange.getWidth(), selectedRange.getHeight() - dy);
                    }
                    if ((cs = this.renderSelectedRange(model, blockColumns, minVisibleUiColumnIndex, _selectedRange)) == null) continue;
                    double csx = rendererHelper.getColumnOffset(blockColumns, _selectedRange.getUiColumnIndex() - minVisibleUiColumnIndex);
                    double csy = rendererHelper.getRowOffset(_selectedRange.getUiRowIndex()) - rendererHelper.getRowOffset(minVisibleUiRowIndex);
                    ((Group)((Group)cs.setX(csx + gridLineStrokeWidth + selectorStrokeWidth / 2.0)).setY(csy + gridLineStrokeWidth + selectorStrokeWidth / 2.0)).setListening(false);
                    g.add((IPrimitive)cs);
                }
                rc.getGroup().add((IPrimitive)g);
            }
        };
    }

    protected Group renderSelectedRange(GridData model, List<GridColumn<?>> blockColumns, int minVisibleUiColumnIndex, SelectedRange selectedRange) {
        Group cellSelector = new Group();
        double gridLineStrokeWidth = this.theme.getBodyGridLine().getStrokeWidth();
        double selectorStrokeWidth = this.theme.getCellSelectorBorder().getStrokeWidth();
        double width = this.getSelectedRangeWidth(blockColumns, minVisibleUiColumnIndex, selectedRange) - (gridLineStrokeWidth + selectorStrokeWidth);
        double height = this.getSelectedRangeHeight(model, selectedRange) - (gridLineStrokeWidth + selectorStrokeWidth);
        Rectangle selector = (Rectangle)this.theme.getCellSelectorBorder().setWidth(width).setHeight(height).setListening(false);
        Rectangle highlight = (Rectangle)this.theme.getCellSelectorBackground().setWidth(width).setHeight(height).setListening(false);
        cellSelector.add((IPrimitive)highlight);
        cellSelector.add((IPrimitive)selector);
        return cellSelector;
    }

    private double getSelectedRangeWidth(List<GridColumn<?>> blockColumns, int minVisibleUiColumnIndex, SelectedRange selectedRange) {
        double width = 0.0;
        for (int columnIndex = 0; columnIndex < selectedRange.getWidth(); ++columnIndex) {
            int relativeColumnIndex = columnIndex + selectedRange.getUiColumnIndex() - minVisibleUiColumnIndex;
            width += blockColumns.get(relativeColumnIndex).getWidth();
        }
        return width;
    }

    private double getSelectedRangeHeight(GridData model, SelectedRange selectedRange) {
        double height = 0.0;
        for (int rowIndex = 0; rowIndex < selectedRange.getHeight(); ++rowIndex) {
            height += model.getRow(selectedRange.getUiRowIndex() + rowIndex).getHeight();
        }
        return height;
    }

    @Override
    public List<GridRenderer.RendererCommand> renderHeader(GridData model, GridHeaderRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        double x;
        ArrayList<GridRenderer.RendererCommand> commands = new ArrayList<GridRenderer.RendererCommand>();
        List<GridColumn<?>> allBlockColumns = context.getAllColumns();
        List<GridColumn<?>> visibleBlockColumns = context.getBlockColumns();
        double headerRowsHeight = renderingInformation.getHeaderRowsHeight();
        double headerRowsYOffset = renderingInformation.getHeaderRowsYOffset();
        double cx = 0.0;
        for (GridColumn<?> column : visibleBlockColumns) {
            if (!column.isVisible()) continue;
            x = cx;
            double w = column.getWidth();
            Rectangle header = column.isLinked() ? this.theme.getHeaderLinkBackground(column) : this.theme.getHeaderBackground(column);
            if (header != null) {
                commands.add(rc -> {
                    if (this.columnRenderingConstraint.apply(rc.isSelectionLayer(), column).booleanValue()) {
                        ((Rectangle)((Rectangle)header.setWidth(w).setListening(true)).setHeight(headerRowsHeight).setY(headerRowsYOffset)).setX(x);
                        rc.getGroup().add((IPrimitive)header);
                    }
                });
            }
            cx += w;
        }
        cx = 0.0;
        for (GridColumn<?> column : visibleBlockColumns) {
            if (!column.isVisible()) continue;
            double columnWidth = column.getWidth();
            int columnIndex = visibleBlockColumns.indexOf(column);
            GridHeaderColumnRenderContext headerCellRenderContext = new GridHeaderColumnRenderContext(cx, allBlockColumns, visibleBlockColumns, columnIndex, model, this);
            commands.addAll(column.getColumnRenderer().renderHeader(column.getHeaderMetaData(), headerCellRenderContext, renderingInformation, this.columnRenderingConstraint));
            cx += columnWidth;
        }
        cx = 0.0;
        for (GridColumn<?> column : visibleBlockColumns) {
            if (!column.isVisible()) continue;
            x = cx;
            double w = column.getWidth();
            if (column.isLinked()) {
                commands.add(rc -> {
                    if (this.columnRenderingConstraint.apply(rc.isSelectionLayer(), column).booleanValue()) {
                        Text t = (Text)((Text)this.theme.getBodyText().setFontFamily(LINK_FONT_FAMILY).setFontSize(10.0).setText(LINK_ICON).setY(headerRowsYOffset + 10.0)).setX(x + w - 10.0);
                        rc.getGroup().add((IPrimitive)t);
                    }
                });
            }
            cx += w;
        }
        commands.add(this.renderHeaderBodyDivider(rendererHelper.getWidth(visibleBlockColumns)));
        return commands;
    }

    @Override
    public GridRenderer.RendererCommand renderHeaderBodyDivider(double width) {
        return rc -> {
            if (!rc.isSelectionLayer()) {
                Line divider = this.theme.getGridHeaderBodyDivider();
                divider.setPoints(new Point2DArray(new Point2D(0.0, this.getHeaderHeight() + 0.5), new Point2D[]{new Point2D(width, this.getHeaderHeight() + 0.5)}));
                rc.getGroup().add((IPrimitive)divider);
            }
        };
    }

    @Override
    public List<GridRenderer.RendererCommand> renderBody(GridData model, GridBodyRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation) {
        ArrayList<GridRenderer.RendererCommand> commands = new ArrayList<GridRenderer.RendererCommand>();
        double absoluteGridX = context.getAbsoluteGridX();
        double absoluteGridY = context.getAbsoluteGridY();
        double absoluteColumnOffsetX = context.getAbsoluteColumnOffsetX();
        double clipMinY = context.getClipMinY();
        double clipMinX = context.getClipMinX();
        int minVisibleRowIndex = context.getMinVisibleRowIndex();
        int maxVisibleRowIndex = context.getMaxVisibleRowIndex();
        List<GridColumn<?>> blockColumns = context.getBlockColumns();
        Transform transform = context.getTransform();
        GridRenderer renderer = context.getRenderer();
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<Double> visibleRowOffsets = renderingInformation.getVisibleRowOffsets();
        double columnHeight = visibleRowOffsets.get(maxVisibleRowIndex - minVisibleRowIndex) - visibleRowOffsets.get(0) + model.getRow(maxVisibleRowIndex).getHeight();
        double cx = 0.0;
        for (GridColumn<?> column : blockColumns) {
            if (!column.isVisible()) continue;
            double x = cx;
            double columnWidth = column.getWidth();
            commands.add(rc -> {
                if (this.columnRenderingConstraint.apply(rc.isSelectionLayer(), column).booleanValue()) {
                    Rectangle body = (Rectangle)((Rectangle)this.theme.getBodyBackground(column).setWidth(columnWidth).setListening(true)).setHeight(columnHeight).setX(x);
                    rc.getGroup().add((IPrimitive)body);
                }
            });
            cx += columnWidth;
        }
        cx = 0.0;
        for (GridColumn<?> column : blockColumns) {
            if (!column.isVisible()) continue;
            double columnWidth = column.getWidth();
            double columnRelativeX = rendererHelper.getColumnOffset(blockColumns, blockColumns.indexOf(column)) + absoluteColumnOffsetX;
            boolean isFloating = floatingBlockInformation.getColumns().contains(column);
            GridBodyColumnRenderContext columnContext = new GridBodyColumnRenderContext(cx, absoluteGridX, absoluteGridY, absoluteGridX + columnRelativeX, clipMinY, clipMinX, minVisibleRowIndex, maxVisibleRowIndex, isFloating, model, transform, renderer);
            commands.addAll(column.getColumnRenderer().renderColumn(column, columnContext, rendererHelper, renderingInformation, this.columnRenderingConstraint));
            cx += columnWidth;
        }
        return commands;
    }

    @Override
    public GridRenderer.RendererCommand renderGridBoundary(GridBoundaryRenderContext context) {
        return rc -> {
            if (!rc.isSelectionLayer()) {
                double x = context.getX();
                double y = context.getY();
                double width = context.getWidth();
                double height = context.getHeight();
                Rectangle boundary = (Rectangle)((Rectangle)((Rectangle)this.theme.getGridBoundary().setWidth(width).setHeight(height).setListening(false)).setX(x + 0.5)).setY(y + 0.5);
                rc.getGroup().add((IPrimitive)boundary);
            }
        };
    }

    @Override
    public boolean onGroupingToggle(double cellX, double cellY, double cellWidth, double cellHeight) {
        return GroupingToggle.onHotSpot(cellX, cellY, cellWidth, cellHeight);
    }

    @Override
    public void setColumnRenderConstraint(BiFunction<Boolean, GridColumn<?>, Boolean> columnRenderingConstraint) {
        this.columnRenderingConstraint = columnRenderingConstraint;
    }
}

