/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.NodeMouseClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseClickHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.animation.MergableGridWidgetCollapseRowsAnimation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.animation.MergableGridWidgetExpandRowsAnimation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;

public class BaseGridWidgetMouseClickHandler
implements NodeMouseClickHandler {
    protected GridData gridModel;
    protected GridWidget gridWidget;
    protected BaseGridRendererHelper rendererHelper;
    protected GridSelectionManager selectionManager;
    protected GridRenderer renderer;

    public BaseGridWidgetMouseClickHandler(GridWidget gridWidget, GridSelectionManager selectionManager, GridRenderer renderer) {
        this.gridWidget = gridWidget;
        this.gridModel = gridWidget.getModel();
        this.rendererHelper = gridWidget.getRendererHelper();
        this.selectionManager = selectionManager;
        this.renderer = renderer;
    }

    public void onNodeMouseClick(NodeMouseClickEvent event) {
        if (!this.gridWidget.isVisible()) {
            return;
        }
        if (!this.handleHeaderCellClick(event) && !this.handleBodyCellClick(event)) {
            this.selectionManager.select(this.gridWidget);
        }
    }

    protected boolean handleHeaderCellClick(NodeMouseClickEvent event) {
        double headerMaxY;
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        double cx = ap.getX();
        double cy = ap.getY();
        Group header = this.gridWidget.getHeader();
        double headerRowsYOffset = this.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        double d = headerMaxY = header == null ? this.renderer.getHeaderHeight() : this.renderer.getHeaderHeight() + header.getY();
        if (cx < 0.0 || cx > this.gridWidget.getWidth()) {
            return false;
        }
        if (cy < headerMinY || cy > headerMaxY) {
            return false;
        }
        BaseGridRendererHelper.ColumnInformation ci = this.rendererHelper.getColumnInformation(cx);
        GridColumn<?> column = ci.getColumn();
        if (column == null) {
            return false;
        }
        if (column.isLinked()) {
            GridColumn<?> link = column.getLink();
            this.selectionManager.selectLinkedColumn(link);
            return true;
        }
        return false;
    }

    protected double getHeaderRowsYOffset() {
        GridData model = this.gridWidget.getModel();
        int headerRowCount = model.getHeaderRowCount();
        double headerHeight = this.renderer.getHeaderHeight();
        double headerRowHeight = this.renderer.getHeaderRowHeight();
        double headerRowsHeight = headerRowHeight * (double)headerRowCount;
        double headerRowsYOffset = headerHeight - headerRowsHeight;
        return headerRowsYOffset;
    }

    protected boolean handleBodyCellClick(NodeMouseClickEvent event) {
        double headerMaxY;
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        double cx = ap.getX();
        double cy = ap.getY();
        Group header = this.gridWidget.getHeader();
        double d = headerMaxY = header == null ? this.renderer.getHeaderHeight() : this.renderer.getHeaderHeight() + header.getY();
        if (cx < 0.0 || cx > this.gridWidget.getWidth()) {
            return false;
        }
        if (cy < headerMaxY || cy > this.gridWidget.getHeight()) {
            return false;
        }
        if (this.gridModel.getRowCount() == 0) {
            return false;
        }
        int uiRowIndex = 0;
        double offsetY = cy - this.renderer.getHeaderHeight();
        while (true) {
            GridRow gridRow;
            GridRow row = this.gridModel.getRow(uiRowIndex);
            if (!(gridRow.getHeight() < offsetY)) break;
            offsetY -= row.getHeight();
            ++uiRowIndex;
        }
        if (uiRowIndex < 0 || uiRowIndex > this.gridModel.getRowCount() - 1) {
            return false;
        }
        BaseGridRendererHelper.ColumnInformation ci = this.rendererHelper.getColumnInformation(cx);
        double offsetX = ci.getOffsetX();
        GridColumn<?> column = ci.getColumn();
        List<GridColumn<?>> columns = this.gridModel.getColumns();
        if (column == null) {
            return false;
        }
        int uiColumnIndex = ci.getUiColumnIndex();
        if (uiColumnIndex < 0 || uiColumnIndex > columns.size() - 1) {
            return false;
        }
        GridCell<?> cell = this.gridModel.getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return false;
        }
        if (cell.getMergedCellCount() < 2) {
            return false;
        }
        GridRow gridRow = this.gridModel.getRow(uiRowIndex);
        GridColumn<?> gridColumn = columns.get(uiColumnIndex);
        GridCell<?> nextRowCell = this.gridModel.getCell(uiRowIndex + 1, uiColumnIndex);
        double cellX = cx - offsetX;
        double cellY = cy - this.rendererHelper.getRowOffset(uiRowIndex) - this.renderer.getHeaderHeight();
        if (!this.gridWidget.onGroupingToggle(cellX, cellY, gridColumn.getWidth(), gridRow.getHeight())) {
            return false;
        }
        if (!nextRowCell.isCollapsed()) {
            this.collapseRows(uiRowIndex, uiColumnIndex, cell.getMergedCellCount());
        } else {
            this.expandRows(uiRowIndex, uiColumnIndex, cell.getMergedCellCount());
        }
        return true;
    }

    void collapseRows(int uiRowIndex, int uiColumnIndex, int rowCount) {
        MergableGridWidgetCollapseRowsAnimation a = new MergableGridWidgetCollapseRowsAnimation(this.gridWidget, uiRowIndex, uiColumnIndex, rowCount);
        a.run();
    }

    void expandRows(int uiRowIndex, int uiColumnIndex, int rowCount) {
        MergableGridWidgetExpandRowsAnimation a = new MergableGridWidgetExpandRowsAnimation(this.gridWidget, uiRowIndex, uiColumnIndex, rowCount);
        a.run();
    }
}

