/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public class BaseGridRendererHelper {
    private final GridWidget view;

    public BaseGridRendererHelper(GridWidget view) {
        this.view = (GridWidget)PortablePreconditions.checkNotNull((String)"view", (Object)view);
    }

    public double getColumnOffset(GridColumn<?> column) {
        GridData model = this.view.getModel();
        int columnIndex = model.getColumns().indexOf(column);
        if (columnIndex == -1) {
            return 0.0;
        }
        return this.getColumnOffset(columnIndex);
    }

    public double getColumnOffset(int columnIndex) {
        double columnOffset = 0.0;
        GridData model = this.view.getModel();
        List<GridColumn<?>> columns = model.getColumns();
        for (int i = 0; i < columnIndex; ++i) {
            GridColumn<?> column = columns.get(i);
            if (!column.isVisible()) continue;
            columnOffset += column.getWidth();
        }
        return columnOffset;
    }

    public double getColumnOffset(List<GridColumn<?>> columns, int columnIndex) {
        double columnOffset = 0.0;
        for (int idx = 0; idx < columnIndex; ++idx) {
            GridColumn<?> column = columns.get(idx);
            if (!column.isVisible()) continue;
            columnOffset += column.getWidth();
        }
        return columnOffset;
    }

    public double getRowOffset(GridRow row) {
        GridData model = this.view.getModel();
        int rowIndex = model.getRows().indexOf(row);
        return this.getRowOffset(rowIndex);
    }

    public double getRowOffset(int rowIndex) {
        double rowOffset = 0.0;
        GridData model = this.view.getModel();
        for (int i = 0; i < rowIndex; ++i) {
            GridRow row = model.getRow(i);
            rowOffset += row.getHeight();
        }
        return rowOffset;
    }

    public double getWidth(List<GridColumn<?>> columns) {
        double width = 0.0;
        for (GridColumn<?> column : columns) {
            if (!column.isVisible()) continue;
            width += column.getWidth();
        }
        return width;
    }

    public RenderingInformation getRenderingInformation() {
        GridRow row;
        GridData model = this.view.getModel();
        Bounds bounds = this.getVisibleBounds();
        ArrayList allColumns = new ArrayList();
        ArrayList bodyColumns = new ArrayList();
        ArrayList floatingColumns = new ArrayList();
        double vpX = bounds.getX();
        double vpY = bounds.getY();
        double vpWidth = bounds.getWidth();
        double vpHeight = bounds.getHeight();
        double headerOffsetY = this.getHeaderOffsetY();
        GridRenderer renderer = this.view.getRenderer();
        if (this.view.getAbsoluteX() > vpX + vpWidth) {
            return null;
        }
        if (this.view.getAbsoluteX() + this.view.getWidth() < vpX) {
            return null;
        }
        if (this.view.getAbsoluteY() > vpY + vpHeight) {
            return null;
        }
        if (this.view.getAbsoluteY() + this.view.getHeight() < vpY) {
            return null;
        }
        boolean isFixedHeader = false;
        boolean isFloatingHeader = false;
        if (this.view.isSelected()) {
            if (this.view.getAbsoluteY() < vpY) {
                if (this.view.getAbsoluteY() + this.view.getHeight() > vpY + renderer.getHeaderHeight()) {
                    isFloatingHeader = true;
                } else {
                    isFixedHeader = true;
                }
            } else if (this.view.getAbsoluteY() <= vpY + vpHeight) {
                isFixedHeader = true;
            }
        } else if (this.view.getAbsoluteY() + renderer.getHeaderHeight() > vpY && this.view.getAbsoluteY() < vpY + vpHeight) {
            isFixedHeader = true;
        }
        int minVisibleRowIndex = 0;
        if (model.getRowCount() > 0) {
            double clipTop = vpY - this.view.getAbsoluteY() - (isFloatingHeader ? 0.0 : renderer.getHeaderHeight());
            while (true) {
                GridRow gridRow;
                row = model.getRow(minVisibleRowIndex);
                if (!(gridRow.getHeight() < clipTop) || minVisibleRowIndex >= model.getRowCount() - 1) break;
                clipTop -= row.getHeight();
                ++minVisibleRowIndex;
            }
        }
        int maxVisibleRowIndex = minVisibleRowIndex;
        if (model.getRowCount() > 0) {
            double clipBottom = vpY - this.view.getAbsoluteY() - renderer.getHeaderHeight() + vpHeight - this.getRowOffset(minVisibleRowIndex);
            while (true) {
                GridRow gridRow;
                row = model.getRow(maxVisibleRowIndex);
                if (!(gridRow.getHeight() < clipBottom) || maxVisibleRowIndex >= model.getRowCount() - 1) break;
                clipBottom -= row.getHeight();
                ++maxVisibleRowIndex;
            }
        }
        double x = 0.0;
        for (GridColumn<?> column : model.getColumns()) {
            allColumns.add(column);
            double floatingColumnsWidth = this.getWidth(floatingColumns);
            if (this.view.getAbsoluteX() + x + column.getWidth() >= vpX + floatingColumnsWidth && this.view.getAbsoluteX() + x < vpX + vpWidth) {
                bodyColumns.add(column);
            }
            if (this.view.isSelected() && column.isFloatable() && this.view.getAbsoluteX() + x < vpX + floatingColumnsWidth) {
                allColumns.remove(column);
                bodyColumns.remove(column);
                floatingColumns.add(column);
            }
            if (!column.isVisible()) continue;
            x += column.getWidth();
        }
        if (this.view.getAbsoluteX() + x - vpX < this.getWidth(floatingColumns)) {
            allColumns.clear();
            bodyColumns.clear();
            floatingColumns.clear();
            allColumns.addAll(model.getColumns());
            x = 0.0;
            for (GridColumn<?> column : model.getColumns()) {
                if (this.view.getAbsoluteX() + x + column.getWidth() >= vpX && this.view.getAbsoluteX() + x < vpX + vpWidth) {
                    bodyColumns.add(column);
                }
                if (!column.isVisible()) continue;
                x += column.getWidth();
            }
        }
        double bodyOffsetY = this.getRowOffset(minVisibleRowIndex) + renderer.getHeaderHeight();
        double offsetX = bodyColumns.size() > 0 ? this.getColumnOffset((GridColumn)bodyColumns.get(0)) : 0.0;
        double floatingOffsetX = this.getFloatingColumnOffset();
        RenderingBlockInformation bodyBlockInformation = new RenderingBlockInformation(bodyColumns, offsetX, headerOffsetY, bodyOffsetY, this.getWidth(bodyColumns));
        RenderingBlockInformation floatingBlockInformation = new RenderingBlockInformation(floatingColumns, floatingOffsetX, headerOffsetY, bodyOffsetY, this.getWidth(floatingColumns));
        ArrayList<Double> visibleRowOffsets = new ArrayList<Double>();
        if (model.getRowCount() > 0) {
            double visibleRowOffset = this.getRowOffset(minVisibleRowIndex);
            for (int rowIndex = minVisibleRowIndex; rowIndex <= maxVisibleRowIndex; ++rowIndex) {
                visibleRowOffsets.add(visibleRowOffset);
                visibleRowOffset += model.getRow(rowIndex).getHeight();
            }
        }
        int headerRowCount = model.getHeaderRowCount();
        double headerHeight = renderer.getHeaderHeight();
        double headerRowHeight = renderer.getHeaderRowHeight();
        double headerRowsHeight = headerRowHeight * (double)headerRowCount;
        double headerRowsYOffset = headerHeight - headerRowsHeight;
        return new RenderingInformation(bounds, allColumns, bodyBlockInformation, floatingBlockInformation, minVisibleRowIndex, maxVisibleRowIndex, visibleRowOffsets, isFixedHeader, isFloatingHeader, headerRowsHeight, headerRowCount, headerRowsYOffset);
    }

    public ColumnInformation getColumnInformation(double cx) {
        double columnWidth;
        RenderingInformation renderingInformation = this.getRenderingInformation();
        if (renderingInformation == null) {
            return new ColumnInformation();
        }
        GridData model = this.view.getModel();
        List<GridColumn<?>> columns = model.getColumns();
        RenderingBlockInformation bodyBlockInformation = renderingInformation.getBodyBlockInformation();
        RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> bodyColumns = bodyBlockInformation.getColumns();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double offsetX = floatingX;
        GridColumn<?> column = null;
        for (GridColumn<?> gridColumn : floatingColumns) {
            if (!gridColumn.isVisible()) continue;
            columnWidth = gridColumn.getWidth();
            if (cx > offsetX && cx < offsetX + columnWidth) {
                column = gridColumn;
                break;
            }
            offsetX += columnWidth;
        }
        if (column != null) {
            return new ColumnInformation(column, columns.indexOf(column), offsetX);
        }
        offsetX = bodyBlockInformation.getX();
        for (GridColumn<?> gridColumn : bodyColumns) {
            if (!gridColumn.isVisible()) continue;
            columnWidth = gridColumn.getWidth();
            if (offsetX + columnWidth > floatingX + floatingWidth && cx > offsetX && cx < offsetX + columnWidth) {
                column = gridColumn;
                break;
            }
            offsetX += columnWidth;
        }
        if (column == null) {
            return new ColumnInformation();
        }
        return new ColumnInformation(column, columns.indexOf(column), offsetX);
    }

    private Bounds getVisibleBounds() {
        GridLayer gridLayer = (GridLayer)this.view.getLayer();
        Bounds bounds = gridLayer.getVisibleBounds();
        return bounds;
    }

    private double getFloatingColumnOffset() {
        Bounds bounds = this.getVisibleBounds();
        return bounds.getX() - this.view.getAbsoluteX();
    }

    private double getHeaderOffsetY() {
        double vpY = this.getVisibleBounds().getY();
        if (this.view.isSelected() && this.view.getAbsoluteY() < vpY && this.view.getAbsoluteY() + this.view.getHeight() > vpY + this.view.getRenderer().getHeaderHeight()) {
            return vpY - this.view.getAbsoluteY();
        }
        return 0.0;
    }

    public static class RenderingBlockInformation {
        private final List<GridColumn<?>> columns;
        private final double x;
        private final double headerY;
        private final double bodyY;
        private final double width;

        public RenderingBlockInformation(List<GridColumn<?>> columns, double x, double headerY, double bodyY, double width) {
            this.columns = columns;
            this.x = x;
            this.headerY = headerY;
            this.bodyY = bodyY;
            this.width = width;
        }

        public List<GridColumn<?>> getColumns() {
            return Collections.unmodifiableList(this.columns);
        }

        public double getX() {
            return this.x;
        }

        public double getHeaderY() {
            return this.headerY;
        }

        public double getBodyY() {
            return this.bodyY;
        }

        public double getWidth() {
            return this.width;
        }
    }

    public static class RenderingInformation {
        private final Bounds bounds;
        private final List<GridColumn<?>> allColumns;
        private final RenderingBlockInformation bodyBlockInformation;
        private final RenderingBlockInformation floatingBlockInformation;
        private final int minVisibleRowIndex;
        private final int maxVisibleRowIndex;
        private final List<Double> visibleRowOffsets;
        private final boolean isFixedHeader;
        private final boolean isFloatingHeader;
        private final double headerRowsHeight;
        private final double headerRowCount;
        private final double headerRowsYOffset;

        public RenderingInformation(Bounds bounds, List<GridColumn<?>> allColumns, RenderingBlockInformation bodyBlockInformation, RenderingBlockInformation floatingBlockInformation, int minVisibleRowIndex, int maxVisibleRowIndex, List<Double> visibleRowOffsets, boolean isFixedHeader, boolean isFloatingHeader, double headerRowsHeight, double headerRowCount, double headerRowsYOffset) {
            this.bounds = bounds;
            this.allColumns = allColumns;
            this.bodyBlockInformation = bodyBlockInformation;
            this.floatingBlockInformation = floatingBlockInformation;
            this.minVisibleRowIndex = minVisibleRowIndex;
            this.maxVisibleRowIndex = maxVisibleRowIndex;
            this.visibleRowOffsets = visibleRowOffsets;
            this.isFixedHeader = isFixedHeader;
            this.isFloatingHeader = isFloatingHeader;
            this.headerRowsHeight = headerRowsHeight;
            this.headerRowCount = headerRowCount;
            this.headerRowsYOffset = headerRowsYOffset;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        public List<GridColumn<?>> getAllColumns() {
            return this.allColumns;
        }

        public RenderingBlockInformation getBodyBlockInformation() {
            return this.bodyBlockInformation;
        }

        public RenderingBlockInformation getFloatingBlockInformation() {
            return this.floatingBlockInformation;
        }

        public int getMinVisibleRowIndex() {
            return this.minVisibleRowIndex;
        }

        public int getMaxVisibleRowIndex() {
            return this.maxVisibleRowIndex;
        }

        public List<Double> getVisibleRowOffsets() {
            return Collections.unmodifiableList(this.visibleRowOffsets);
        }

        public boolean isFixedHeader() {
            return this.isFixedHeader;
        }

        public boolean isFloatingHeader() {
            return this.isFloatingHeader;
        }

        public double getHeaderRowsHeight() {
            return this.headerRowsHeight;
        }

        public double getHeaderRowCount() {
            return this.headerRowCount;
        }

        public double getHeaderRowsYOffset() {
            return this.headerRowsYOffset;
        }
    }

    public static class ColumnInformation {
        private GridColumn<?> column;
        private int uiColumnIndex = -1;
        private double offsetX = -1.0;

        ColumnInformation() {
        }

        public ColumnInformation(GridColumn<?> column, int uiColumnIndex, double offsetX) {
            this.column = column;
            this.uiColumnIndex = uiColumnIndex;
            this.offsetX = offsetX;
        }

        public GridColumn<?> getColumn() {
            return this.column;
        }

        public int getUiColumnIndex() {
            return this.uiColumnIndex;
        }

        public double getOffsetX() {
            return this.offsetX;
        }
    }
}

