/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.scrollbars;

import com.ait.lienzo.client.core.shape.IDrawable;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Viewport;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollHandler;

class GridLienzoScrollBounds {
    private static final Double DEFAULT_VALUE = 0.0;
    private final GridLienzoScrollHandler gridLienzoScrollHandler;
    private Bounds defaultBounds;

    GridLienzoScrollBounds(GridLienzoScrollHandler GridLienzoScrollHandler2) {
        this.gridLienzoScrollHandler = GridLienzoScrollHandler2;
    }

    Double maxBoundX() {
        List<Double> boundsValues = this.getVisibleGridWidgets().map(gridWidget -> gridWidget.getX() + gridWidget.getWidth()).collect(Collectors.toList());
        this.addExtraBounds(boundsValues, bounds -> bounds.getX() + bounds.getWidth());
        return this.maxValue(boundsValues);
    }

    Double maxBoundY() {
        List<Double> boundsValues = this.getVisibleGridWidgets().map(gridWidget -> gridWidget.getY() + gridWidget.getHeight()).collect(Collectors.toList());
        this.addExtraBounds(boundsValues, bounds -> bounds.getY() + bounds.getHeight());
        return this.maxValue(boundsValues);
    }

    Double minBoundX() {
        List<Double> boundsValues = this.getVisibleGridWidgets().map(IPrimitive::getX).collect(Collectors.toList());
        this.addExtraBounds(boundsValues, Bounds::getX);
        return this.minValue(boundsValues);
    }

    Double minBoundY() {
        List<Double> boundsValues = this.getVisibleGridWidgets().map(IPrimitive::getY).collect(Collectors.toList());
        this.addExtraBounds(boundsValues, Bounds::getY);
        return this.minValue(boundsValues);
    }

    Stream<GridWidget> getVisibleGridWidgets() {
        return this.getGridWidgets().stream().filter(IDrawable::isVisible);
    }

    private double maxValue(List<Double> boundsValues) {
        return boundsValues.stream().reduce(Double::max).orElse(DEFAULT_VALUE);
    }

    private double minValue(List<Double> boundsValues) {
        return boundsValues.stream().reduce(Double::min).orElse(DEFAULT_VALUE);
    }

    private void addExtraBounds(List<Double> bounds, Function<Bounds, Double> function) {
        if (this.hasVisibleBounds().booleanValue()) {
            bounds.add(function.apply(this.getVisibleBounds()));
        }
        if (this.hasDefaultBounds().booleanValue() && !this.isGridPinned()) {
            bounds.add(function.apply(this.getDefaultBounds()));
        }
    }

    Bounds getVisibleBounds() {
        return this.getDefaultGridLayer().getVisibleBounds();
    }

    Boolean hasDefaultBounds() {
        return Optional.ofNullable(this.getDefaultBounds()).isPresent();
    }

    Boolean hasVisibleBounds() {
        Viewport viewport = this.getDefaultGridLayer().getViewport();
        return Optional.ofNullable(viewport).isPresent();
    }

    Bounds getDefaultBounds() {
        return this.defaultBounds;
    }

    void setDefaultBounds(Bounds defaultBounds) {
        this.defaultBounds = defaultBounds;
    }

    DefaultGridLayer getDefaultGridLayer() {
        return this.gridLienzoScrollHandler.getDefaultGridLayer();
    }

    Set<GridWidget> getGridWidgets() {
        return this.getDefaultGridLayer().getGridWidgets();
    }

    private boolean isGridPinned() {
        return this.getDefaultGridLayer().isGridPinned();
    }
}

