/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl;

import com.ait.lienzo.client.core.shape.BoundingBoxPathClipper;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPathClipper;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.ColumnRenderingStrategyFlattened;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.ColumnRenderingStrategyMerged;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public abstract class BaseGridColumnRenderer<T>
implements GridColumnRenderer<T> {
    @Override
    public List<GridRenderer.RendererCommand> renderHeader(List<GridColumn.HeaderMetaData> headerMetaData, GridHeaderColumnRenderContext context, BaseGridRendererHelper.RenderingInformation renderingInformation, BiFunction<Boolean, GridColumn<?>, Boolean> columnRenderingConstraint) {
        GridData model = context.getModel();
        GridRenderer renderer = context.getRenderer();
        GridRendererTheme theme = renderer.getTheme();
        double x = context.getX();
        double headerRowsHeight = renderingInformation.getHeaderRowsHeight();
        double headerRowsYOffset = renderingInformation.getHeaderRowsYOffset();
        double rowHeight = headerRowsHeight / (double)headerMetaData.size();
        List<GridColumn<?>> allBlockColumns = context.getAllColumns();
        List<GridColumn<?>> visibleBlockColumns = context.getBlockColumns();
        int headerStartColumnIndex = allBlockColumns.indexOf(visibleBlockColumns.get(0));
        int headerColumnIndex = allBlockColumns.indexOf(visibleBlockColumns.get(context.getColumnIndex()));
        GridColumn<?> column = visibleBlockColumns.get(context.getColumnIndex());
        ArrayList<GridRenderer.RendererCommand> commands = new ArrayList<GridRenderer.RendererCommand>();
        commands.add(rc -> {
            if (!rc.isSelectionLayer()) {
                Group g = (Group)new Group().setX(x);
                MultiPath headerGrid = (MultiPath)theme.getHeaderGridLine().setY(headerRowsYOffset);
                for (int headerRowIndex = 0; headerRowIndex < headerMetaData.size(); ++headerRowIndex) {
                    boolean skip;
                    int blockStartColumnIndex = this.getBlockStartColumnIndex(allBlockColumns, (GridColumn.HeaderMetaData)headerMetaData.get(headerRowIndex), headerRowIndex, headerColumnIndex);
                    int blockEndColumnIndex = this.getBlockEndColumnIndex(allBlockColumns, (GridColumn.HeaderMetaData)headerMetaData.get(headerRowIndex), headerRowIndex, headerColumnIndex);
                    if (headerColumnIndex < model.getColumnCount() - 1 && blockEndColumnIndex == headerColumnIndex) {
                        double hx = column.getWidth();
                        headerGrid.M(hx + 0.5, (double)headerRowIndex * rowHeight).L(hx + 0.5, (double)(headerRowIndex + 1) * rowHeight);
                    }
                    if (blockStartColumnIndex >= headerStartColumnIndex) {
                        skip = headerColumnIndex > blockStartColumnIndex;
                    } else {
                        boolean bl = skip = headerColumnIndex > headerStartColumnIndex;
                    }
                    if (skip) continue;
                    double offsetX = this.getBlockOffset(allBlockColumns, blockStartColumnIndex, headerColumnIndex);
                    double blockWidth = this.getBlockWidth(allBlockColumns, blockStartColumnIndex, blockEndColumnIndex);
                    if (headerRowIndex <= 0) continue;
                    headerGrid.M(offsetX, (double)headerRowIndex * rowHeight + 0.5).L(offsetX + blockWidth, (double)headerRowIndex * rowHeight + 0.5);
                }
                g.add((IPrimitive)headerGrid);
                rc.getGroup().add((IPrimitive)g);
            }
        });
        commands.add(rc -> {
            if (!rc.isSelectionLayer()) {
                Group g = (Group)new Group().setX(x);
                for (int headerRowIndex = 0; headerRowIndex < headerMetaData.size(); ++headerRowIndex) {
                    boolean skip;
                    int blockStartColumnIndex = this.getBlockStartColumnIndex(allBlockColumns, (GridColumn.HeaderMetaData)headerMetaData.get(headerRowIndex), headerRowIndex, headerColumnIndex);
                    int blockEndColumnIndex = this.getBlockEndColumnIndex(allBlockColumns, (GridColumn.HeaderMetaData)headerMetaData.get(headerRowIndex), headerRowIndex, headerColumnIndex);
                    if (blockStartColumnIndex >= headerStartColumnIndex) {
                        skip = headerColumnIndex > blockStartColumnIndex;
                    } else {
                        boolean bl = skip = headerColumnIndex > headerStartColumnIndex;
                    }
                    if (skip) continue;
                    double offsetX = this.getBlockOffset(allBlockColumns, blockStartColumnIndex, headerColumnIndex);
                    double blockWidth = this.getBlockWidth(allBlockColumns, blockStartColumnIndex, blockEndColumnIndex);
                    Group headerGroup = this.renderHeaderContent(context, headerMetaData, headerRowIndex, blockWidth, rowHeight);
                    BoundingBox bb = new BoundingBox(0.0, 0.0, blockWidth, rowHeight);
                    IPathClipper clipper = this.getBoundingBoxPathClipper(bb);
                    headerGroup.setX(offsetX);
                    headerGroup.setY(headerRowsYOffset + (double)headerRowIndex * rowHeight);
                    headerGroup.setPathClipper(clipper);
                    clipper.setActive(true);
                    g.add((IPrimitive)headerGroup);
                }
                rc.getGroup().add((IPrimitive)g);
            }
        });
        return commands;
    }

    protected IPathClipper getBoundingBoxPathClipper(BoundingBox bb) {
        return new BoundingBoxPathClipper(bb);
    }

    protected Group renderHeaderContent(GridHeaderColumnRenderContext context, List<GridColumn.HeaderMetaData> headerMetaData, int headerRowIndex, double blockWidth, double rowHeight) {
        Group headerGroup = (Group)GWT.create(Group.class);
        String title = headerMetaData.get(headerRowIndex).getTitle();
        Text t = context.getRenderer().getTheme().getHeaderText();
        t.setText(title);
        t.setListening(false);
        t.setX(blockWidth / 2.0);
        t.setY(rowHeight / 2.0);
        headerGroup.add((IPrimitive)t);
        return headerGroup;
    }

    private int getBlockStartColumnIndex(List<GridColumn<?>> allColumns, GridColumn.HeaderMetaData headerMetaData, int headerRowIndex, int headerColumnIndex) {
        GridColumn<?> candidateColumn;
        List<GridColumn.HeaderMetaData> candidateHeaderMetaData;
        int candidateHeaderColumnIndex = headerColumnIndex;
        if (candidateHeaderColumnIndex == 0) {
            return candidateHeaderColumnIndex;
        }
        while (candidateHeaderColumnIndex > 0 && (candidateHeaderMetaData = (candidateColumn = allColumns.get(candidateHeaderColumnIndex - 1)).getHeaderMetaData()).size() - 1 >= headerRowIndex && candidateHeaderMetaData.get(headerRowIndex).equals(headerMetaData)) {
            --candidateHeaderColumnIndex;
        }
        return candidateHeaderColumnIndex;
    }

    private int getBlockEndColumnIndex(List<GridColumn<?>> allColumns, GridColumn.HeaderMetaData headerMetaData, int headerRowIndex, int headerColumnIndex) {
        GridColumn<?> candidateColumn;
        List<GridColumn.HeaderMetaData> candidateHeaderMetaData;
        int candidateHeaderColumnIndex = headerColumnIndex;
        if (candidateHeaderColumnIndex == allColumns.size() - 1) {
            return candidateHeaderColumnIndex;
        }
        while (candidateHeaderColumnIndex < allColumns.size() - 1 && (candidateHeaderMetaData = (candidateColumn = allColumns.get(candidateHeaderColumnIndex + 1)).getHeaderMetaData()).size() - 1 >= headerRowIndex && candidateHeaderMetaData.get(headerRowIndex).equals(headerMetaData)) {
            ++candidateHeaderColumnIndex;
        }
        return candidateHeaderColumnIndex;
    }

    private double getBlockOffset(List<GridColumn<?>> allColumns, int blockStartColumnIndex, int headerColumnIndex) {
        double blockOffset = 0.0;
        for (int blockColumnIndex = blockStartColumnIndex; blockColumnIndex < headerColumnIndex; ++blockColumnIndex) {
            GridColumn<?> column = allColumns.get(blockColumnIndex);
            if (!column.isVisible()) continue;
            blockOffset -= column.getWidth();
        }
        return blockOffset;
    }

    private double getBlockWidth(List<GridColumn<?>> allColumns, int blockStartColumnIndex, int blockEndColumnIndex) {
        double blockWidth = 0.0;
        for (int blockColumnIndex = blockStartColumnIndex; blockColumnIndex <= blockEndColumnIndex; ++blockColumnIndex) {
            GridColumn<?> column = allColumns.get(blockColumnIndex);
            if (!column.isVisible()) continue;
            blockWidth += column.getWidth();
        }
        return blockWidth;
    }

    @Override
    public List<GridRenderer.RendererCommand> renderColumn(GridColumn<?> column, GridBodyColumnRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation, BiFunction<Boolean, GridColumn<?>, Boolean> columnRenderingConstraint) {
        if (context.getModel().isMerged()) {
            return ColumnRenderingStrategyMerged.render(column, context, rendererHelper, renderingInformation, columnRenderingConstraint);
        }
        return ColumnRenderingStrategyFlattened.render(column, context, rendererHelper, renderingInformation, columnRenderingConstraint);
    }
}

