/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.SelectionsTransformer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.SelectedRange;

public class DefaultSelectionsTransformer
implements SelectionsTransformer {
    protected final GridData model;
    protected final List<GridColumn<?>> columns;

    public DefaultSelectionsTransformer(GridData model, List<GridColumn<?>> columns) {
        this.model = Objects.requireNonNull(model, "model");
        this.columns = Objects.requireNonNull(columns, "columns");
    }

    @Override
    public List<SelectedRange> transformToSelectedRanges() {
        int currentUiColumnIndex = -1;
        SelectedRange currentRange = null;
        List<GridData.SelectedCell> orderedSelectedCells = this.sortSelectedCells();
        TreeMap<Integer, List<SelectedRange>> orderedSelectedRanges = new TreeMap<Integer, List<SelectedRange>>();
        for (GridData.SelectedCell selectedCell : orderedSelectedCells) {
            int n = selectedCell.getRowIndex();
            int scColumnIndex = selectedCell.getColumnIndex();
            int uiColumnIndex = ColumnIndexUtilities.findUiColumnIndex(this.getApplicableColumns(), scColumnIndex);
            if (uiColumnIndex != currentUiColumnIndex) {
                this.storeSelectedRange(orderedSelectedRanges, currentRange, currentUiColumnIndex);
                currentUiColumnIndex = uiColumnIndex;
                currentRange = new SelectedRange(n, uiColumnIndex, 1, 1);
                continue;
            }
            if (n == currentRange.getUiRowIndex() + currentRange.getHeight()) {
                currentRange.setHeight(currentRange.getHeight() + 1);
                continue;
            }
            this.storeSelectedRange(orderedSelectedRanges, currentRange, uiColumnIndex);
            currentRange = new SelectedRange(n, uiColumnIndex, 1, 1);
        }
        this.storeSelectedRange(orderedSelectedRanges, currentRange, currentUiColumnIndex);
        int maxColumnIndex = this.getMaximumColumnIndex(orderedSelectedRanges);
        for (Map.Entry entry : orderedSelectedRanges.entrySet()) {
            for (SelectedRange selectedRange : (List)entry.getValue()) {
                List mergeRanges;
                for (int mergeColumnIndex = (Integer)entry.getKey() + 1; mergeColumnIndex <= maxColumnIndex && (mergeRanges = (List)orderedSelectedRanges.get(mergeColumnIndex)) != null; ++mergeColumnIndex) {
                    Iterator srIterator = mergeRanges.iterator();
                    while (srIterator.hasNext()) {
                        SelectedRange mergeRange = (SelectedRange)srIterator.next();
                        if (selectedRange.getUiRowIndex() != mergeRange.getUiRowIndex() || selectedRange.getUiColumnIndex() + selectedRange.getWidth() != mergeRange.getUiColumnIndex() || selectedRange.getHeight() != mergeRange.getHeight()) continue;
                        selectedRange.setWidth(selectedRange.getWidth() + 1);
                        srIterator.remove();
                    }
                }
            }
        }
        ArrayList<SelectedRange> arrayList = new ArrayList<SelectedRange>();
        for (List ranges : orderedSelectedRanges.values()) {
            arrayList.addAll(ranges);
        }
        return arrayList;
    }

    private int getMaximumColumnIndex(Map<Integer, List<SelectedRange>> selectedRanges) {
        int maxColumnIndex = 0;
        for (Integer idx : selectedRanges.keySet()) {
            maxColumnIndex = Math.max(maxColumnIndex, idx);
        }
        return maxColumnIndex;
    }

    private void storeSelectedRange(Map<Integer, List<SelectedRange>> orderedSelectedRanges, SelectedRange currentRange, int uiColumnIndex) {
        if (currentRange != null) {
            List<SelectedRange> selectedRanges = orderedSelectedRanges.get(uiColumnIndex);
            if (selectedRanges == null) {
                selectedRanges = new ArrayList<SelectedRange>();
                orderedSelectedRanges.put(uiColumnIndex, selectedRanges);
            }
            selectedRanges.add(currentRange);
        }
    }

    protected List<GridColumn<?>> getApplicableColumns() {
        return this.model.getColumns();
    }

    private List<GridData.SelectedCell> sortSelectedCells() {
        ArrayList<GridData.SelectedCell> selectedCells = new ArrayList<GridData.SelectedCell>();
        for (GridData.SelectedCell sc : this.model.getSelectedCells()) {
            if (!this.isSelectionInColumns(sc)) continue;
            selectedCells.add(sc);
        }
        final int rowCount = this.model.getRowCount();
        Collections.sort(selectedCells, new Comparator<GridData.SelectedCell>(){

            @Override
            public int compare(GridData.SelectedCell o1, GridData.SelectedCell o2) {
                int o1Index = o1.getRowIndex() + o1.getColumnIndex() * rowCount;
                int o2Index = o2.getRowIndex() + o2.getColumnIndex() * rowCount;
                return o1Index - o2Index;
            }
        });
        return selectedCells;
    }

    private boolean isSelectionInColumns(GridData.SelectedCell sc) {
        int scColumnIndex = sc.getColumnIndex();
        for (GridColumn<?> column : this.columns) {
            int columnIndex = column.getIndex();
            if (scColumnIndex != columnIndex) continue;
            return true;
        }
        return false;
    }
}

