/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.scrollbars;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollBounds;
import org.uberfire.ext.wires.core.grids.client.widget.scrollbars.GridLienzoScrollHandler;

class GridLienzoScrollPosition {
    private final GridLienzoScrollHandler gridLienzoScrollHandler;

    GridLienzoScrollPosition(GridLienzoScrollHandler gridLienzoScrollHandler) {
        this.gridLienzoScrollHandler = gridLienzoScrollHandler;
    }

    Double currentRelativeX() {
        Double delta = this.deltaX();
        return delta == 0.0 ? 0.0 : 100.0 * this.currentX() / delta;
    }

    Double currentRelativeY() {
        Double delta = this.deltaY();
        return delta == 0.0 ? 0.0 : 100.0 * this.currentY() / delta;
    }

    Double currentPositionX(Double level) {
        Double position = this.deltaX() * level / 100.0;
        return -(this.bounds().minBoundX() + position);
    }

    Double currentPositionY(Double level) {
        Double position = this.deltaY() * level / 100.0;
        return -(this.bounds().minBoundY() + position);
    }

    Double deltaX() {
        return this.bounds().maxBoundX() - this.bounds().minBoundX() - this.getVisibleBounds().getWidth();
    }

    Double deltaY() {
        return this.bounds().maxBoundY() - this.bounds().minBoundY() - this.getVisibleBounds().getHeight();
    }

    private Double currentX() {
        return -(this.getTransform().getTranslateX() / this.getTransform().getScaleX() + this.bounds().minBoundX());
    }

    private Double currentY() {
        return -(this.getTransform().getTranslateY() / this.getTransform().getScaleY() + this.bounds().minBoundY());
    }

    Transform getTransform() {
        Viewport viewport = this.getDefaultGridLayer().getViewport();
        return viewport.getTransform();
    }

    Bounds getVisibleBounds() {
        return this.getDefaultGridLayer().getVisibleBounds();
    }

    GridLienzoScrollBounds bounds() {
        return this.gridLienzoScrollHandler.scrollBounds();
    }

    private DefaultGridLayer getDefaultGridLayer() {
        return this.gridLienzoScrollHandler.getDefaultGridLayer();
    }
}

