/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl;

import com.ait.lienzo.client.core.types.Transform;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;

public class BoundaryTransformMediator
implements TransformMediator {
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;

    public BoundaryTransformMediator() {
        this.minX = Double.NEGATIVE_INFINITY;
        this.minY = Double.NEGATIVE_INFINITY;
        this.maxX = Double.POSITIVE_INFINITY;
        this.maxY = Double.POSITIVE_INFINITY;
    }

    public BoundaryTransformMediator(Bounds bounds) {
        this.setBounds(bounds);
    }

    public void setBounds(Bounds bounds) {
        this.minX = bounds.getX();
        this.minY = bounds.getY();
        this.maxX = this.minX + bounds.getWidth();
        this.maxY = this.minY + bounds.getHeight();
    }

    @Override
    public Transform adjust(Transform transform, Bounds visibleBounds) {
        Transform newTransform = transform.copy();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        double translateX = newTransform.getTranslateX();
        double translateY = newTransform.getTranslateY();
        double scaledTranslateX = translateX / scaleX;
        double scaledTranslateY = translateY / scaleY;
        double visibleBoundsWidth = visibleBounds.getWidth();
        double visibleBoundsHeight = visibleBounds.getHeight();
        if (-scaledTranslateX < this.minX) {
            newTransform = newTransform.translate(-scaledTranslateX - this.minX, 0.0);
        }
        if (-scaledTranslateY < this.minY) {
            newTransform = newTransform.translate(0.0, -scaledTranslateY - this.minY);
        }
        if (-scaledTranslateX + visibleBoundsWidth > this.maxX) {
            newTransform = newTransform.translate(-scaledTranslateX + visibleBoundsWidth - this.maxX, 0.0);
        }
        if (-scaledTranslateY + visibleBoundsHeight > this.maxY) {
            newTransform = newTransform.translate(0.0, -scaledTranslateY + visibleBoundsHeight - this.maxY);
        }
        return newTransform;
    }
}

