/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import java.util.List;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

public class BaseGridDataIndexManager {
    private final GridData gridData;

    public BaseGridDataIndexManager(GridData gridData) {
        this.gridData = gridData;
    }

    public void onMerge(boolean isMerged) {
        if (isMerged) {
            this.fullIndex();
        } else {
            this.reset();
        }
    }

    private void fullIndex() {
        List<GridColumn<?>> columns = this.gridData.getColumns();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            this.indexColumn(columnIndex);
        }
    }

    public void indexColumn(int columnIndex) {
        List<GridRow> rows = this.gridData.getRows();
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            GridCell<?> nextRowCell;
            int maxRowIndex;
            GridCell<?> currentRowCell = this.gridData.getCell(rowIndex, columnIndex);
            if (currentRowCell == null) continue;
            currentRowCell.reset();
            for (maxRowIndex = rowIndex + 1; maxRowIndex < rows.size() && (nextRowCell = this.gridData.getCell(maxRowIndex, columnIndex)) != null && nextRowCell.equals(currentRowCell); ++maxRowIndex) {
            }
            if (maxRowIndex - rowIndex <= 1) continue;
            for (int i = rowIndex; i < maxRowIndex; ++i) {
                GridRow row = rows.get(i);
                GridCell<?> cell = this.gridData.getCell(i, columnIndex);
                ((BaseGridCell)cell).setMergedCellCount(0);
                this.updateRowMergedCells(row);
            }
            GridRow row = rows.get(rowIndex);
            GridCell<?> cell = this.gridData.getCell(rowIndex, columnIndex);
            ((BaseGridCell)cell).setMergedCellCount(maxRowIndex - rowIndex);
            this.updateRowMergedCells(row);
            rowIndex = maxRowIndex - 1;
        }
    }

    private void reset() {
        List<GridRow> rows = this.gridData.getRows();
        for (GridRow row : rows) {
            row.reset();
        }
    }

    public void onInsertRow(int rowIndex) {
        if (!this.gridData.isMerged()) {
            return;
        }
        List<GridColumn<?>> columns = this.gridData.getColumns();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            GridColumn<?> column = columns.get(columnIndex);
            int _columnIndex = column.getIndex();
            if (rowIndex > 0) {
                this.updateMergeMetaData(rowIndex - 1, _columnIndex);
            }
            if (rowIndex >= this.gridData.getRowCount() - 1) continue;
            this.updateMergeMetaData(rowIndex + 1, _columnIndex);
        }
    }

    public void onDeleteRow(GridData.Range range) {
        if (!this.gridData.isMerged()) {
            return;
        }
        int minRowIndex = range.getMinRowIndex();
        int maxRowIndex = range.getMaxRowIndex();
        List<GridColumn<?>> columns = this.gridData.getColumns();
        for (int _rowIndex = minRowIndex; _rowIndex <= maxRowIndex; ++_rowIndex) {
            for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
                GridColumn<?> column = columns.get(columnIndex);
                int _columnIndex = column.getIndex();
                if (minRowIndex < this.gridData.getRowCount()) {
                    this.updateMergeMetaData(minRowIndex, _columnIndex);
                    continue;
                }
                if (minRowIndex <= 0) continue;
                this.updateMergeMetaData(minRowIndex - 1, _columnIndex);
            }
        }
    }

    private void updateMergeMetaData(int rowIndex, int columnIndex) {
        this.updateMergeMetaData(rowIndex, columnIndex, 0, this.gridData.getRowCount());
    }

    private void updateMergeMetaData(int rowIndex, int columnIndex, int minRowIndex, int maxRowIndex) {
        GridRow currentRow = this.gridData.getRow(rowIndex);
        GridCell<?> currentRowCell = currentRow.getCells().get(columnIndex);
        int minBlockRowIndex = this.findMinRowIndex(rowIndex, columnIndex, minRowIndex, currentRowCell);
        int maxBlockRowIndex = this.findMaxRowIndex(rowIndex, columnIndex, maxRowIndex, currentRowCell);
        this.updateMergeMetaData(minBlockRowIndex, maxBlockRowIndex, columnIndex);
    }

    public void onSetCell(GridData.Range range, int columnIndex) {
        int minRowIndex = range.getMinRowIndex();
        this.updateMergeMetaData(minRowIndex, columnIndex);
    }

    public void onDeleteCell(GridData.Range range, int columnIndex) {
        int minRowIndex = range.getMinRowIndex();
        int maxRowIndex = range.getMaxRowIndex();
        for (int i = minRowIndex; i <= maxRowIndex; ++i) {
            GridRow row = this.gridData.getRow(i);
            this.updateRowMergedCells(row);
        }
        this.updateMergeMetaData(minRowIndex, columnIndex);
    }

    public void onCollapseCell(int rowIndex, int columnIndex) {
        int i;
        GridRow nextRow;
        GridCell<?> nextRowCell;
        int minRowIndex = rowIndex;
        int maxRowIndex = rowIndex + 1;
        List<GridRow> rows = this.gridData.getRows();
        List<GridColumn<?>> columns = this.gridData.getColumns();
        GridRow currentRow = rows.get(rowIndex);
        GridCell<?> currentRowCell = currentRow.getCells().get(columnIndex);
        if (currentRowCell == null) {
            return;
        }
        if (currentRowCell.getMergedCellCount() == 0) {
            GridRow previousRow;
            GridCell<?> previousRowCell;
            while ((previousRowCell = (previousRow = rows.get(--minRowIndex)).getCells().get(columnIndex)).getMergedCellCount() <= 0 && minRowIndex > 0) {
            }
        }
        while (maxRowIndex < rows.size() && (nextRowCell = (nextRow = rows.get(maxRowIndex)).getCells().get(columnIndex)) != null && nextRowCell.getMergedCellCount() <= 0) {
            ++maxRowIndex;
        }
        for (i = minRowIndex + 1; i < maxRowIndex; ++i) {
            rows.get(i).collapse();
        }
        for (i = 0; i < columns.size(); ++i) {
            int _columnIndex = columns.get(i).getIndex();
            if (_columnIndex == columnIndex) continue;
            this.updateMergeMetaDataOnCollapseTopSplitRows(minRowIndex, maxRowIndex, _columnIndex);
            this.updateMergeMetaDataOnCollapseBottomSplitRows(minRowIndex, maxRowIndex, _columnIndex);
        }
    }

    private void updateMergeMetaDataOnCollapseTopSplitRows(int minRowIndex, int maxRowIndex, int columnIndex) {
        GridRow collapsedRow;
        GridCell<?> collapsedCell;
        if (minRowIndex < 1) {
            return;
        }
        List<GridRow> rows = this.gridData.getRows();
        GridRow checkTopRow = this.gridData.getRow(minRowIndex - 1);
        GridCell<?> checkTopCell = checkTopRow.getCells().get(columnIndex);
        if (checkTopCell == null) {
            return;
        }
        if (checkTopCell.getMergedCellCount() == 1) {
            return;
        }
        boolean splitTopSection = false;
        for (int collapsedRowIndex = minRowIndex; collapsedRowIndex < maxRowIndex && (collapsedCell = (collapsedRow = this.gridData.getRow(collapsedRowIndex)).getCells().get(columnIndex)) != null && collapsedCell.equals(checkTopCell); ++collapsedRowIndex) {
            splitTopSection = collapsedRowIndex < maxRowIndex - 1;
        }
        if (splitTopSection) {
            GridRow nextRow;
            GridCell<?> nextRowCell;
            int checkMaxRowIndex;
            int checkMinRowIndex;
            if (checkTopCell.getMergedCellCount() == 0) {
                GridRow previousRow;
                GridCell<?> previousRowCell;
                for (checkMinRowIndex = minRowIndex - 1; checkMinRowIndex > 0 && (previousRowCell = (previousRow = rows.get(checkMinRowIndex)).getCells().get(columnIndex)) != null && previousRowCell.getMergedCellCount() <= 0; --checkMinRowIndex) {
                }
            }
            if (minRowIndex > checkMinRowIndex) {
                for (int i = checkMinRowIndex; i < minRowIndex; ++i) {
                    GridRow row = rows.get(i);
                    BaseGridCell cell = (BaseGridCell)row.getCells().get(columnIndex);
                    if (cell != null) {
                        cell.setMergedCellCount(0);
                    }
                    this.updateRowMergedCells(row);
                }
                GridRow topSplitRow = rows.get(checkMinRowIndex);
                BaseGridCell topSplitRowCell = (BaseGridCell)topSplitRow.getCells().get(columnIndex);
                if (topSplitRowCell != null) {
                    topSplitRowCell.setMergedCellCount(minRowIndex - checkMinRowIndex);
                }
                this.updateRowMergedCells(topSplitRow);
            }
            boolean foundBottomSplitMarker = false;
            for (checkMaxRowIndex = minRowIndex; checkMaxRowIndex < rows.size() && (nextRowCell = (nextRow = rows.get(checkMaxRowIndex)).getCells().get(columnIndex)) != null; ++checkMaxRowIndex) {
                if (nextRowCell.isCollapsed() && foundBottomSplitMarker) {
                    --checkMaxRowIndex;
                    break;
                }
                if (!nextRowCell.equals(checkTopCell)) break;
                if (nextRowCell.getMergedCellCount() <= 0) continue;
                foundBottomSplitMarker = true;
            }
            if (checkMaxRowIndex > minRowIndex) {
                for (int i = minRowIndex; i < checkMaxRowIndex; ++i) {
                    GridRow row = rows.get(i);
                    BaseGridCell cell = (BaseGridCell)row.getCells().get(columnIndex);
                    if (cell != null) {
                        cell.setMergedCellCount(0);
                    }
                    this.updateRowMergedCells(row);
                }
                GridRow bottomSplitRow = rows.get(minRowIndex);
                BaseGridCell bottomSplitRowCell = (BaseGridCell)bottomSplitRow.getCells().get(columnIndex);
                if (bottomSplitRowCell != null) {
                    bottomSplitRowCell.setMergedCellCount(checkMaxRowIndex - minRowIndex);
                }
                this.updateRowMergedCells(bottomSplitRow);
            }
        }
    }

    private void updateMergeMetaDataOnCollapseBottomSplitRows(int minRowIndex, int maxRowIndex, int columnIndex) {
        GridRow collapsedRow;
        GridCell<?> collapsedCell;
        List<GridRow> rows = this.gridData.getRows();
        if (maxRowIndex == rows.size()) {
            return;
        }
        GridRow checkBottomRow = this.gridData.getRow(maxRowIndex);
        GridCell<?> checkBottomCell = checkBottomRow.getCells().get(columnIndex);
        if (checkBottomCell == null) {
            return;
        }
        if (checkBottomCell.getMergedCellCount() == 1) {
            return;
        }
        boolean splitBottomSection = false;
        for (int collapsedRowIndex = maxRowIndex - 1; collapsedRowIndex >= minRowIndex && (collapsedCell = (collapsedRow = this.gridData.getRow(collapsedRowIndex)).getCells().get(columnIndex)) != null && collapsedCell.equals(checkBottomCell); --collapsedRowIndex) {
            splitBottomSection = collapsedRowIndex > minRowIndex;
        }
        if (splitBottomSection) {
            GridRow nextRow;
            GridCell<?> nextRowCell;
            int checkMaxRowIndex;
            int checkMinRowIndex;
            if (checkBottomCell.getMergedCellCount() == 0) {
                GridRow previousRow;
                GridCell<?> previousRowCell;
                for (checkMinRowIndex = maxRowIndex - 1; checkMinRowIndex > 0 && (previousRowCell = (previousRow = rows.get(checkMinRowIndex)).getCells().get(columnIndex)) != null && previousRowCell.getMergedCellCount() <= 0; --checkMinRowIndex) {
                }
            }
            if (maxRowIndex > checkMinRowIndex) {
                for (int i = checkMinRowIndex; i < maxRowIndex; ++i) {
                    GridRow row = rows.get(i);
                    BaseGridCell cell = (BaseGridCell)row.getCells().get(columnIndex);
                    if (cell != null) {
                        cell.setMergedCellCount(0);
                    }
                    this.updateRowMergedCells(row);
                }
                GridRow topSplitRow = rows.get(checkMinRowIndex);
                BaseGridCell topSplitRowCell = (BaseGridCell)topSplitRow.getCells().get(columnIndex);
                if (topSplitRowCell != null) {
                    topSplitRowCell.setMergedCellCount(maxRowIndex - checkMinRowIndex);
                }
                this.updateRowMergedCells(topSplitRow);
            }
            boolean foundBottomSplitMarker = false;
            for (checkMaxRowIndex = maxRowIndex; checkMaxRowIndex < rows.size() && (nextRowCell = (nextRow = rows.get(checkMaxRowIndex)).getCells().get(columnIndex)) != null; ++checkMaxRowIndex) {
                if (nextRowCell.isCollapsed() && foundBottomSplitMarker) {
                    --checkMaxRowIndex;
                    break;
                }
                if (!nextRowCell.equals(checkBottomCell)) break;
                if (nextRowCell.getMergedCellCount() <= 0) continue;
                foundBottomSplitMarker = true;
            }
            if (checkMaxRowIndex > maxRowIndex) {
                for (int i = maxRowIndex; i < checkMaxRowIndex; ++i) {
                    GridRow row = rows.get(i);
                    BaseGridCell cell = (BaseGridCell)row.getCells().get(columnIndex);
                    if (cell != null) {
                        cell.setMergedCellCount(0);
                    }
                    this.updateRowMergedCells(row);
                }
                GridRow bottomSplitRow = rows.get(maxRowIndex);
                if (bottomSplitRow.getCells().get(columnIndex).getMergedCellCount() == 0) {
                    BaseGridCell bottomSplitRowCell = (BaseGridCell)bottomSplitRow.getCells().get(columnIndex);
                    if (bottomSplitRowCell != null) {
                        bottomSplitRowCell.setMergedCellCount(checkMaxRowIndex - maxRowIndex);
                    }
                    this.updateRowMergedCells(bottomSplitRow);
                }
            }
        }
    }

    public void onExpandCell(int rowIndex, int columnIndex) {
        int i;
        GridRow nextRow;
        GridCell<?> nextRowCell;
        int minRowIndex = rowIndex;
        int maxRowIndex = rowIndex + 1;
        List<GridRow> rows = this.gridData.getRows();
        List<GridColumn<?>> columns = this.gridData.getColumns();
        GridRow currentRow = rows.get(rowIndex);
        GridCell<?> currentRowCell = currentRow.getCells().get(columnIndex);
        if (currentRowCell == null) {
            return;
        }
        if (currentRowCell.getMergedCellCount() == 0) {
            GridRow previousRow;
            GridCell<?> previousRowCell;
            while ((previousRowCell = (previousRow = rows.get(--minRowIndex)).getCells().get(columnIndex)) != null && previousRowCell.getMergedCellCount() <= 0 && minRowIndex > 0) {
            }
        }
        while (maxRowIndex < rows.size() && (nextRowCell = (nextRow = rows.get(maxRowIndex)).getCells().get(columnIndex)) != null && nextRowCell.getMergedCellCount() <= 0) {
            ++maxRowIndex;
        }
        for (i = minRowIndex + 1; i < maxRowIndex; ++i) {
            rows.get(i).expand();
        }
        for (i = 0; i < columns.size(); ++i) {
            int _columnIndex = columns.get(i).getIndex();
            this.updateMergeMetaDataOnExpand(minRowIndex, maxRowIndex, _columnIndex);
            this.updateMergeMetaDataOnExpand(maxRowIndex - 1, maxRowIndex, _columnIndex);
        }
    }

    private void updateMergeMetaDataOnExpand(int expandMinRowIndex, int expandMaxRowIndex, int columnIndex) {
        GridRow bottomSplitRow;
        List<GridRow> rows = this.gridData.getRows();
        GridRow currentRow = this.gridData.getRow(expandMinRowIndex);
        GridCell<?> currentRowCell = currentRow.getCells().get(columnIndex);
        int minRowIndex = this.findMinRowIndex(expandMinRowIndex, columnIndex, 0, currentRowCell);
        int maxRowIndex = this.findMaxRowIndex(expandMinRowIndex, columnIndex, rows.size(), currentRowCell);
        this.updateMergeMetaData(minRowIndex, maxRowIndex, columnIndex);
        GridRow row = rows.get(minRowIndex);
        BaseGridCell cell = (BaseGridCell)row.getCells().get(columnIndex);
        if (maxRowIndex > expandMaxRowIndex && (bottomSplitRow = rows.get(expandMaxRowIndex)).isCollapsed()) {
            BaseGridCell bottomSplitRowCell = (BaseGridCell)bottomSplitRow.getCells().get(columnIndex);
            if (bottomSplitRowCell != null) {
                bottomSplitRowCell.setMergedCellCount(maxRowIndex - expandMaxRowIndex);
            }
            this.updateRowMergedCells(bottomSplitRow);
            bottomSplitRow.expand();
            if (cell != null) {
                cell.setMergedCellCount(expandMaxRowIndex - minRowIndex);
            }
            this.updateRowMergedCells(row);
        }
    }

    public void onMoveRows(List<GridRow> rowsMoved, GridData.Range oldBlockExtent) {
        int _columnIndex;
        if (!this.gridData.isMerged()) {
            return;
        }
        List<GridRow> rows = this.gridData.getRows();
        List<GridColumn<?>> columns = this.gridData.getColumns();
        int oldBlockEnd = oldBlockExtent.getMaxRowIndex();
        int newBlockStart = rows.indexOf(rowsMoved.get(0));
        int newBlockEnd = rows.indexOf(rowsMoved.get(rowsMoved.size() - 1));
        boolean isCollapsedBlock = false;
        for (GridRow gridRow : rowsMoved) {
            if (!gridRow.isCollapsed()) continue;
            isCollapsedBlock = true;
            break;
        }
        for (GridColumn gridColumn : columns) {
            _columnIndex = gridColumn.getIndex();
            if (oldBlockEnd > 0) {
                this.updateMergeMetaData(oldBlockEnd - 1, _columnIndex);
            }
            if (oldBlockEnd < rows.size() - 1) {
                this.updateMergeMetaData(oldBlockEnd + 1, _columnIndex);
            }
            if (oldBlockEnd != rows.size() - 1) continue;
            this.updateMergeMetaData(oldBlockEnd, _columnIndex);
        }
        for (GridColumn gridColumn : columns) {
            _columnIndex = gridColumn.getIndex();
            if (isCollapsedBlock) {
                this.updateMergedMetaDataRowMove(newBlockStart, newBlockEnd, _columnIndex);
                continue;
            }
            if (newBlockStart > 0) {
                this.updateMergeMetaData(newBlockStart - 1, _columnIndex);
            }
            if (newBlockStart < rows.size() - 1) {
                this.updateMergeMetaData(newBlockStart + 1, _columnIndex);
            }
            if (newBlockEnd > 0) {
                this.updateMergeMetaData(newBlockEnd - 1, _columnIndex);
            }
            if (newBlockEnd >= rows.size() - 1) continue;
            this.updateMergeMetaData(newBlockEnd + 1, _columnIndex);
        }
    }

    private void updateMergedMetaDataRowMove(int blockStart, int blockEnd, int columnIndex) {
        int maxBlockRowIndex;
        int minBlockRowIndex;
        GridCell<?> currentRowCell;
        GridRow currentRow;
        if (blockStart > 0) {
            currentRow = this.gridData.getRow(blockStart - 1);
            currentRowCell = currentRow.getCells().get(columnIndex);
            minBlockRowIndex = this.findMinRowIndex(blockStart - 1, columnIndex, 0, currentRowCell);
            maxBlockRowIndex = blockStart;
            this.updateMergeMetaData(minBlockRowIndex, maxBlockRowIndex, columnIndex);
        }
        if (blockEnd < this.gridData.getRowCount() - 1) {
            currentRow = this.gridData.getRow(blockEnd + 1);
            currentRowCell = currentRow.getCells().get(columnIndex);
            minBlockRowIndex = blockEnd + 1;
            maxBlockRowIndex = this.findMaxRowIndex(blockEnd, columnIndex, this.gridData.getRowCount(), currentRowCell);
            this.updateMergeMetaData(minBlockRowIndex, maxBlockRowIndex, columnIndex);
        }
        this.updateMergeMetaData(blockStart, columnIndex, blockStart, blockEnd + 1);
    }

    private int findMinRowIndex(int rowIndex, int columnIndex, int minRowIndex, GridCell<?> currentRowCell) {
        int minBlockRowIndex;
        if (currentRowCell != null) {
            GridRow previousRow;
            GridCell<?> previousRowCell;
            boolean foundTopSplitMarker;
            boolean bl = foundTopSplitMarker = currentRowCell.getMergedCellCount() > 0;
            for (minBlockRowIndex = rowIndex; !(minBlockRowIndex <= minRowIndex || (previousRowCell = (previousRow = this.gridData.getRow(minBlockRowIndex - 1)).getCells().get(columnIndex)) == null || previousRowCell.isCollapsed() && foundTopSplitMarker || !previousRowCell.equals(currentRowCell)); --minBlockRowIndex) {
                if (previousRowCell.getMergedCellCount() <= 0) continue;
                foundTopSplitMarker = true;
            }
        }
        return minBlockRowIndex;
    }

    private int findMaxRowIndex(int rowIndex, int columnIndex, int maxRowIndex, GridCell<?> currentRowCell) {
        GridRow nextRow;
        GridCell<?> nextRowCell;
        int maxBlockRowIndex;
        boolean foundBottomSplitMarker = false;
        for (maxBlockRowIndex = rowIndex + 1; maxBlockRowIndex < maxRowIndex && (nextRowCell = (nextRow = this.gridData.getRow(maxBlockRowIndex)).getCells().get(columnIndex)) != null; ++maxBlockRowIndex) {
            if (nextRowCell.isCollapsed() && foundBottomSplitMarker) {
                --maxBlockRowIndex;
                break;
            }
            if (!nextRowCell.equals(currentRowCell)) break;
            if (nextRowCell.getMergedCellCount() <= 0) continue;
            foundBottomSplitMarker = true;
        }
        return maxBlockRowIndex;
    }

    private void updateMergeMetaData(int minBlockRowIndex, int maxBlockRowIndex, int columnIndex) {
        for (int i = minBlockRowIndex; i < maxBlockRowIndex; ++i) {
            GridRow row = this.gridData.getRow(i);
            BaseGridCell cell = (BaseGridCell)row.getCells().get(columnIndex);
            if (cell != null) {
                cell.setMergedCellCount(0);
            }
            this.updateRowMergedCells(row);
        }
        GridRow row = this.gridData.getRow(minBlockRowIndex);
        BaseGridCell cell = (BaseGridCell)row.getCells().get(columnIndex);
        if (cell != null) {
            cell.setMergedCellCount(maxBlockRowIndex - minBlockRowIndex);
        }
        this.updateRowMergedCells(row);
    }

    private void updateRowMergedCells(GridRow row) {
        for (GridCell<?> cell : row.getCells().values()) {
            if (!cell.isMerged()) continue;
            ((BaseGridRow)row).setHasMergedCells(true);
            return;
        }
        ((BaseGridRow)row).setHasMergedCells(false);
    }
}

