/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import java.util.List;
import java.util.Objects;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public abstract class BaseKeyboardOperation
implements KeyboardOperation {
    protected GridLayer gridLayer;

    public BaseKeyboardOperation(GridLayer gridLayer) {
        this.gridLayer = Objects.requireNonNull(gridLayer, "gridLayer");
    }

    @Override
    public KeyboardOperation.TriStateBoolean isShiftKeyDown() {
        return KeyboardOperation.TriStateBoolean.DONT_CARE;
    }

    @Override
    public KeyboardOperation.TriStateBoolean isControlKeyDown() {
        return KeyboardOperation.TriStateBoolean.DONT_CARE;
    }

    @Override
    public boolean isExecutable(GridWidget gridWidget) {
        GridData gridModel = gridWidget.getModel();
        int rowCount = gridModel.getRowCount();
        int columnCount = gridModel.getColumnCount();
        return rowCount != 0 && columnCount != 0;
    }

    protected boolean scrollSelectedCellIntoView(GridWidget gridWidget) {
        if (!this.isSelectionOriginSet(gridWidget) && !this.isHeaderSelectionOriginSet(gridWidget)) {
            return false;
        }
        boolean isHeaderCellSelected = false;
        if (!this.isSelectionOriginSet(gridWidget) && this.isHeaderSelectionOriginSet(gridWidget)) {
            isHeaderCellSelected = true;
        }
        if (!this.isGridColumnCandidateForScroll(gridWidget, isHeaderCellSelected)) {
            return false;
        }
        double dx = this.getCellScrollDeltaX(gridWidget, isHeaderCellSelected);
        double dy = this.getCellScrollDeltaY(gridWidget, isHeaderCellSelected);
        if (dx != 0.0 || dy != 0.0) {
            this.adjustViewportTransform(this.gridLayer.getViewport(), new Point2D(dx, dy));
        }
        return true;
    }

    private boolean isSelectionOriginSet(GridWidget selectedGridWidget) {
        GridData gridModel = selectedGridWidget.getModel();
        GridData.SelectedCell origin = gridModel.getSelectedCellsOrigin();
        return origin != null;
    }

    private boolean isHeaderSelectionOriginSet(GridWidget selectedGridWidget) {
        GridData gridModel = selectedGridWidget.getModel();
        return !gridModel.getSelectedHeaderCells().isEmpty();
    }

    private boolean isGridColumnCandidateForScroll(GridWidget gridWidget, boolean isHeaderCellSelected) {
        GridColumn<?> column;
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        if (Objects.isNull(renderingInformation)) {
            return false;
        }
        GridData gridModel = gridWidget.getModel();
        List<GridColumn<?>> columns = gridModel.getColumns();
        GridData.SelectedCell origin = this.getSelectedCellOrigin(gridModel, isHeaderCellSelected);
        int uiColumnIndex = ColumnIndexUtilities.findUiColumnIndex(columns, origin.getColumnIndex());
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        List<GridColumn<?>> floatingColumns = floatingBlockInformation.getColumns();
        return !floatingColumns.contains(column = columns.get(uiColumnIndex));
    }

    private double getCellScrollDeltaX(GridWidget gridWidget, boolean isHeaderCellSelected) {
        GridData gridModel = gridWidget.getModel();
        List<GridColumn<?>> columns = gridModel.getColumns();
        GridData.SelectedCell origin = this.getSelectedCellOrigin(gridModel, isHeaderCellSelected);
        int uiColumnIndex = ColumnIndexUtilities.findUiColumnIndex(columns, origin.getColumnIndex());
        double dx = 0.0;
        Bounds bounds = this.gridLayer.getVisibleBounds();
        double columnWidth = columns.get(uiColumnIndex).getWidth();
        double gridCellX = gridWidget.getX() + gridWidget.getRendererHelper().getColumnOffset(uiColumnIndex);
        if (gridCellX + columnWidth >= bounds.getX() + bounds.getWidth()) {
            dx = bounds.getX() + bounds.getWidth() - gridCellX - columnWidth;
        } else if (gridCellX <= bounds.getX()) {
            dx = bounds.getX() - gridCellX;
        }
        return dx;
    }

    private double getCellScrollDeltaY(GridWidget gridWidget, boolean isHeaderCellSelected) {
        GridData gridModel = gridWidget.getModel();
        GridData.SelectedCell origin = this.getSelectedCellOrigin(gridModel, isHeaderCellSelected);
        int uiRowIndex = origin.getRowIndex();
        double dy = 0.0;
        Bounds bounds = this.gridLayer.getVisibleBounds();
        int headerRowCount = gridModel.getHeaderRowCount();
        double headerHeight = gridWidget.getRenderer().getHeaderHeight();
        double rowHeight = isHeaderCellSelected ? gridWidget.getRenderer().getHeaderRowHeight() : gridModel.getRow(uiRowIndex).getHeight();
        double headerYOffset = isHeaderCellSelected ? headerHeight - (double)headerRowCount * rowHeight : headerHeight;
        double rowOffset = isHeaderCellSelected ? rowHeight * (double)uiRowIndex : gridWidget.getRendererHelper().getRowOffset(uiRowIndex);
        double gridCellY = gridWidget.getY() + headerYOffset + rowOffset;
        if (gridCellY + rowHeight >= bounds.getY() + bounds.getHeight()) {
            dy = bounds.getY() + bounds.getHeight() - gridCellY - rowHeight;
        } else if (gridCellY <= bounds.getY() + headerYOffset) {
            dy = bounds.getY() + headerYOffset - gridCellY;
        }
        return dy;
    }

    protected GridData.SelectedCell getSelectedCellOrigin(GridData gridModel, boolean isHeaderCellSelected) {
        if (isHeaderCellSelected) {
            List<GridData.SelectedCell> selectedHeaderCells = gridModel.getSelectedHeaderCells();
            if (39 == this.getKeyCode()) {
                return selectedHeaderCells.get(selectedHeaderCells.size() - 1);
            }
            return selectedHeaderCells.get(0);
        }
        return gridModel.getSelectedCellsOrigin();
    }

    private void adjustViewportTransform(Viewport vp, Point2D delta) {
        Transform transform = vp.getTransform();
        Transform t = transform.copy().getInverse();
        Point2D translation = new Point2D(t.getTranslateX(), t.getTranslateY()).mul(-1.0);
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        transform.reset();
        Point2D frameLocation = translation.add(delta);
        transform.scale(scaleX, scaleY).translate(frameLocation.getX(), frameLocation.getY());
    }
}

