/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.animation.MergableGridWidgetCollapseRowsAnimation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.animation.MergableGridWidgetExpandRowsAnimation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

public class DefaultGridWidgetCollapsedCellMouseEventHandler
implements NodeMouseEventHandler {
    protected GridRenderer renderer;

    public DefaultGridWidgetCollapsedCellMouseEventHandler(GridRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public boolean onNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        if (this.isDNDOperationInProgress(gridWidget)) {
            return false;
        }
        boolean isHandled = false;
        if (uiRowIndex.isPresent() && uiColumnIndex.isPresent()) {
            isHandled = this.handleBodyCell(gridWidget, relativeLocation, uiRowIndex.get(), uiColumnIndex.get(), event);
        }
        return isHandled;
    }

    @Override
    public boolean handleBodyCell(GridWidget gridWidget, Point2D relativeLocation, int uiRowIndex, int uiColumnIndex, AbstractNodeMouseEvent event) {
        GridData gridData = gridWidget.getModel();
        List<GridColumn<?>> gridColumns = gridData.getColumns();
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        GridCell<?> cell = gridData.getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return false;
        }
        if (cell.getMergedCellCount() < 2) {
            return false;
        }
        double cy = relativeLocation.getY();
        double cx = relativeLocation.getX();
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(cx);
        double offsetX = ci.getOffsetX();
        GridRow gridRow = gridData.getRow(uiRowIndex);
        GridColumn<?> gridColumn = gridColumns.get(uiColumnIndex);
        GridCell<?> nextRowCell = gridData.getCell(uiRowIndex + 1, uiColumnIndex);
        double cellX = cx - offsetX;
        double cellY = cy - rendererHelper.getRowOffset(uiRowIndex) - this.renderer.getHeaderHeight();
        if (!gridWidget.onGroupingToggle(cellX, cellY, gridColumn.getWidth(), gridRow.getHeight())) {
            return false;
        }
        if (!nextRowCell.isCollapsed()) {
            this.collapseRows(gridWidget, uiRowIndex, uiColumnIndex, cell.getMergedCellCount());
        } else {
            this.expandRows(gridWidget, uiRowIndex, uiColumnIndex, cell.getMergedCellCount());
        }
        return true;
    }

    void collapseRows(GridWidget gridWidget, int uiRowIndex, int uiColumnIndex, int rowCount) {
        MergableGridWidgetCollapseRowsAnimation a = new MergableGridWidgetCollapseRowsAnimation(gridWidget, uiRowIndex, uiColumnIndex, rowCount);
        a.run();
    }

    void expandRows(GridWidget gridWidget, int uiRowIndex, int uiColumnIndex, int rowCount) {
        MergableGridWidgetExpandRowsAnimation a = new MergableGridWidgetExpandRowsAnimation(gridWidget, uiRowIndex, uiColumnIndex, rowCount);
        a.run();
    }
}

