/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.util;

import java.util.List;
import java.util.Objects;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

public class ColumnIndexUtilities {
    public static int findUiColumnIndex(List<GridColumn<?>> columns, int modelColumnIndex) {
        for (int uiColumnIndex = 0; uiColumnIndex < columns.size(); ++uiColumnIndex) {
            GridColumn<?> c = columns.get(uiColumnIndex);
            if (c.getIndex() != modelColumnIndex) continue;
            return uiColumnIndex;
        }
        throw new IllegalStateException("Column was not found!");
    }

    public static int getHeaderBlockStartColumnIndex(List<GridColumn<?>> allColumns, GridColumn.HeaderMetaData headerMetaData, int headerRowIndex, int headerColumnIndex) {
        GridColumn<?> candidateColumn;
        List<GridColumn.HeaderMetaData> candidateHeaderMetaData;
        int candidateHeaderColumnIndex = headerColumnIndex;
        if (candidateHeaderColumnIndex == 0) {
            return candidateHeaderColumnIndex;
        }
        while (candidateHeaderColumnIndex > 0 && (candidateHeaderMetaData = (candidateColumn = allColumns.get(candidateHeaderColumnIndex - 1)).getHeaderMetaData()).size() - 1 >= headerRowIndex && Objects.equals(candidateHeaderMetaData.get(headerRowIndex), headerMetaData)) {
            --candidateHeaderColumnIndex;
        }
        return candidateHeaderColumnIndex;
    }

    public static int getHeaderBlockEndColumnIndex(List<GridColumn<?>> allColumns, GridColumn.HeaderMetaData headerMetaData, int headerRowIndex, int headerColumnIndex) {
        GridColumn<?> candidateColumn;
        List<GridColumn.HeaderMetaData> candidateHeaderMetaData;
        int candidateHeaderColumnIndex = headerColumnIndex;
        if (candidateHeaderColumnIndex >= allColumns.size() - 1) {
            return allColumns.size() - 1;
        }
        while (candidateHeaderColumnIndex < allColumns.size() - 1 && (candidateHeaderMetaData = (candidateColumn = allColumns.get(candidateHeaderColumnIndex + 1)).getHeaderMetaData()).size() - 1 >= headerRowIndex && Objects.equals(candidateHeaderMetaData.get(headerRowIndex), headerMetaData)) {
            ++candidateHeaderColumnIndex;
        }
        return candidateHeaderColumnIndex;
    }

    public static int getMaxUiHeaderRowIndexOfColumn(GridData model, int uiColumnIndex) {
        return model.getColumns().get(uiColumnIndex).getHeaderMetaData().size() - 1;
    }
}

