/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl;

import com.ait.lienzo.client.core.types.Transform;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;

public class GridTransformMediator
implements TransformMediator {
    private final GridWidget gridWidget;

    public GridTransformMediator(GridWidget gridWidget) {
        this.gridWidget = gridWidget;
    }

    @Override
    public Transform adjust(Transform transform, Bounds visibleBounds) {
        Transform newTransform = transform.copy();
        double minX = this.gridWidget.getX();
        double minY = this.gridWidget.getY();
        double gridWidth = this.gridWidget.getWidth();
        double gridHeight = this.gridWidget.getHeight();
        double maxX = this.gridWidget.getX() + gridWidth;
        double maxY = this.gridWidget.getY() + gridHeight;
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        double translateX = newTransform.getTranslateX();
        double translateY = newTransform.getTranslateY();
        double scaledTranslateX = translateX / scaleX;
        double scaledTranslateY = translateY / scaleY;
        double visibleBoundsWidth = visibleBounds.getWidth();
        double visibleBoundsHeight = visibleBounds.getHeight();
        if (gridWidth <= visibleBoundsWidth) {
            newTransform = newTransform.translate(-scaledTranslateX - minX, 0.0);
        } else {
            if (-scaledTranslateX < minX) {
                newTransform = newTransform.translate(-scaledTranslateX - minX, 0.0);
            }
            if (-scaledTranslateX + visibleBoundsWidth > maxX) {
                newTransform = newTransform.translate(-scaledTranslateX + visibleBoundsWidth - maxX, 0.0);
            }
        }
        if (gridHeight <= visibleBoundsHeight) {
            newTransform = newTransform.translate(0.0, -scaledTranslateY - minY);
        } else {
            if (-scaledTranslateY < minY) {
                newTransform = newTransform.translate(0.0, -scaledTranslateY - minY);
            }
            if (-scaledTranslateY + visibleBoundsHeight > maxY) {
                newTransform = newTransform.translate(0.0, -scaledTranslateY + visibleBoundsHeight - maxY);
            }
        }
        return newTransform;
    }
}

