/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;

public class DefaultGridWidgetLinkedColumnMouseEventHandler
implements NodeMouseEventHandler {
    protected GridSelectionManager selectionManager;
    protected GridRenderer renderer;

    public DefaultGridWidgetLinkedColumnMouseEventHandler(GridSelectionManager selectionManager, GridRenderer renderer) {
        this.selectionManager = selectionManager;
        this.renderer = renderer;
    }

    @Override
    public boolean onNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        if (this.isDNDOperationInProgress(gridWidget)) {
            return false;
        }
        boolean isHandled = false;
        if (uiHeaderRowIndex.isPresent() && uiHeaderColumnIndex.isPresent()) {
            isHandled = this.handleHeaderCell(gridWidget, relativeLocation, uiHeaderRowIndex.get(), uiHeaderColumnIndex.get(), event);
        }
        return isHandled;
    }

    @Override
    public boolean handleHeaderCell(GridWidget gridWidget, Point2D relativeLocation, int uiHeaderRowIndex, int uiHeaderColumnIndex, AbstractNodeMouseEvent event) {
        double cx;
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(cx = relativeLocation.getX());
        GridColumn<?> column = ci.getColumn();
        if (column == null) {
            return false;
        }
        if (column.isLinked()) {
            GridColumn<?> link = column.getLink();
            this.selectionManager.selectLinkedColumn(link);
            return true;
        }
        return false;
    }
}

