/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class DefaultGridWidgetPinnedModeMouseEventHandler
implements NodeMouseEventHandler {
    protected GridPinnedModeManager pinnedModeManager;
    protected GridRenderer renderer;

    public DefaultGridWidgetPinnedModeMouseEventHandler(GridPinnedModeManager pinnedModeManager, GridRenderer renderer) {
        this.pinnedModeManager = pinnedModeManager;
        this.renderer = renderer;
    }

    @Override
    public boolean onNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        if (this.isDNDOperationInProgress(gridWidget)) {
            return false;
        }
        boolean isHandled = false;
        if (uiHeaderRowIndex.isPresent() && uiHeaderColumnIndex.isPresent()) {
            isHandled = this.handleHeaderCell(gridWidget, relativeLocation, uiHeaderRowIndex.get(), uiHeaderColumnIndex.get(), event);
        }
        return isHandled;
    }

    @Override
    public boolean handleHeaderCell(GridWidget gridWidget, Point2D relativeLocation, int uiHeaderRowIndex, int uiHeaderColumnIndex, AbstractNodeMouseEvent event) {
        double headerMaxY;
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        double cx = relativeLocation.getX();
        double cy = relativeLocation.getY();
        Group header = gridWidget.getHeader();
        BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
        double headerRowsYOffset = ri.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        double d = headerMaxY = header == null ? this.renderer.getHeaderHeight() : this.renderer.getHeaderHeight() + header.getY();
        if (cx < 0.0 || cx > gridWidget.getWidth()) {
            return false;
        }
        if (cy < headerMinY || cy > headerMaxY) {
            return false;
        }
        if (!this.pinnedModeManager.isGridPinned()) {
            this.pinnedModeManager.enterPinnedMode(gridWidget, () -> {});
        } else {
            this.pinnedModeManager.exitPinnedMode(() -> {});
        }
        return true;
    }
}

