/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.ColumnIndexUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.BaseCellSelectionStrategy;

public class HeaderSingleCellSelectionStrategy
extends BaseCellSelectionStrategy {
    public static CellSelectionStrategy INSTANCE = new HeaderSingleCellSelectionStrategy();

    @Override
    public boolean handleSelection(GridData model, int uiHeaderRowIndex, int uiHeaderColumnIndex, boolean isShiftKeyDown, boolean isControlKeyDown) {
        ArrayList<GridData.SelectedCell> originalSelections = new ArrayList<GridData.SelectedCell>(model.getSelectedHeaderCells());
        List<GridColumn<?>> gridColumns = model.getColumns();
        List<GridColumn.HeaderMetaData> headerMetaData = gridColumns.get(uiHeaderColumnIndex).getHeaderMetaData();
        int blockStartColumnIndex = ColumnIndexUtilities.getHeaderBlockStartColumnIndex(gridColumns, headerMetaData.get(uiHeaderRowIndex), uiHeaderRowIndex, uiHeaderColumnIndex);
        int blockEndColumnIndex = ColumnIndexUtilities.getHeaderBlockEndColumnIndex(gridColumns, headerMetaData.get(uiHeaderRowIndex), uiHeaderRowIndex, uiHeaderColumnIndex);
        model.clearSelections();
        IntStream.range(blockStartColumnIndex, blockEndColumnIndex + 1).forEach(blockColumnIndex -> model.selectHeaderCell(uiHeaderRowIndex, blockColumnIndex));
        return this.hasSelectionChanged(model.getSelectedHeaderCells(), originalSelections);
    }
}

