/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.Objects;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;

public class DefaultGridWidgetEditCellMouseEventHandler
implements NodeMouseEventHandler {
    @Override
    public boolean onNodeMouseEvent(GridWidget gridWidget, Point2D relativeLocation, Optional<Integer> uiHeaderRowIndex, Optional<Integer> uiHeaderColumnIndex, Optional<Integer> uiRowIndex, Optional<Integer> uiColumnIndex, AbstractNodeMouseEvent event) {
        if (this.isDNDOperationInProgress(gridWidget)) {
            return false;
        }
        boolean isHandled = false;
        if (uiHeaderRowIndex.isPresent() && uiHeaderColumnIndex.isPresent()) {
            isHandled = this.handleHeaderCell(gridWidget, relativeLocation, uiHeaderRowIndex.get(), uiHeaderColumnIndex.get(), event);
        }
        if (!isHandled && uiRowIndex.isPresent() && uiColumnIndex.isPresent()) {
            isHandled = this.handleBodyCell(gridWidget, relativeLocation, uiRowIndex.get(), uiColumnIndex.get(), event);
        }
        return isHandled;
    }

    @Override
    public boolean handleBodyCell(GridWidget gridWidget, Point2D relativeLocation, int uiRowIndex, int uiColumnIndex, AbstractNodeMouseEvent event) {
        GridData gridData = gridWidget.getModel();
        if (gridData.getSelectedCells().size() == 1) {
            GridCellEditAction cellEditAction;
            GridCell<?> cell = gridData.getCell(uiRowIndex, uiColumnIndex);
            GridCellEditAction gridCellEditAction = cellEditAction = cell == null ? GridCell.DEFAULT_EDIT_ACTION : cell.getSupportedEditAction();
            if (Objects.equals((Object)cellEditAction, (Object)GridCellEditAction.getSupportedEditAction(event))) {
                return gridWidget.startEditingCell(relativeLocation);
            }
        }
        return false;
    }
}

