/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.animation;

import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.animation.IAnimation;
import com.ait.lienzo.client.core.animation.IAnimationCallback;
import com.ait.lienzo.client.core.animation.IAnimationHandle;
import com.ait.lienzo.client.core.animation.TimedAnimation;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.user.client.Command;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class GridWidgetScrollIntoViewAnimation
extends TimedAnimation {
    public GridWidgetScrollIntoViewAnimation(final GridWidget gridWidget, final Command onStartCommand) {
        super(500.0, new IAnimationCallback(){
            private Point2D delta;
            private Point2D startTranslation;
            private AnimationTweener tweener = AnimationTweener.EASE_OUT;

            public void onStart(IAnimation animation, IAnimationHandle handle) {
                Viewport vp = gridWidget.getViewport();
                if (vp.getTransform() == null) {
                    vp.setTransform(new Transform());
                }
                this.startTranslation = this.getViewportTranslation().mul(-1.0);
                Point2D endTranslation = new Point2D(gridWidget.getX(), gridWidget.getY()).mul(-1.0);
                this.delta = new Point2D(endTranslation.getX() - this.startTranslation.getX(), endTranslation.getY() - this.startTranslation.getY());
                onStartCommand.execute();
                gridWidget.getLayer().setListening(false);
                gridWidget.getLayer().batch();
            }

            public void onFrame(IAnimation animation, IAnimationHandle handle) {
                double pct = this.assertPct(animation.getPercent());
                Viewport vp = gridWidget.getViewport();
                Transform transform = vp.getTransform();
                double scaleX = transform.getScaleX();
                double scaleY = transform.getScaleY();
                transform.reset();
                Point2D frameLocation = this.startTranslation.add(this.delta.mul(pct));
                transform.scale(scaleX, scaleY).translate(frameLocation.getX(), frameLocation.getY());
                gridWidget.getLayer().batch();
            }

            public void onClose(IAnimation animation, IAnimationHandle handle) {
                gridWidget.getLayer().setListening(true);
                gridWidget.getLayer().batch();
            }

            private Point2D getViewportTranslation() {
                Viewport vp = gridWidget.getViewport();
                Transform transform = vp.getTransform();
                Transform t = transform.copy().getInverse();
                Point2D p = new Point2D(t.getTranslateX(), t.getTranslateY());
                return p;
            }

            private double assertPct(double pct) {
                if (pct < 0.0) {
                    return 0.0;
                }
                if (pct > 1.0) {
                    return 1.0;
                }
                return this.tweener.apply(pct);
            }
        });
    }
}

