/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Widget;
import java.util.function.Consumer;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.impl.BaseDOMElement;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.SingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.keyboard.KeyDownHandlerCommon;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

public abstract class BaseSingletonDOMElementFactory<T, W extends Widget, E extends BaseDOMElement<T, W>>
implements SingletonDOMElementFactory<W, E> {
    protected final GridLienzoPanel gridPanel;
    protected final GridLayer gridLayer;
    protected final GridWidget gridWidget;
    protected W widget;
    protected E e;

    public BaseSingletonDOMElementFactory(GridLienzoPanel gridPanel, GridLayer gridLayer, GridWidget gridWidget) {
        this.gridPanel = gridPanel;
        this.gridLayer = gridLayer;
        this.gridWidget = gridWidget;
    }

    @Override
    public void attachDomElement(final GridBodyCellRenderContext context, final Consumer<E> onCreation, final Consumer<E> onDisplay) {
        this.gridLayer.batch(new GridLayerRedrawManager.PrioritizedCommand(Integer.MAX_VALUE){

            public void execute() {
                Object domElement = BaseSingletonDOMElementFactory.this.createDomElement(BaseSingletonDOMElementFactory.this.gridLayer, BaseSingletonDOMElementFactory.this.gridWidget);
                BaseSingletonDOMElementFactory.this.registerHandlers(BaseSingletonDOMElementFactory.this.widget, domElement);
                ((BaseDOMElement)domElement).setContext(context);
                ((BaseDOMElement)domElement).initialise(context);
                onCreation.accept(domElement);
                ((BaseDOMElement)domElement).attach();
                onDisplay.accept(domElement);
            }
        });
    }

    @Override
    public E createDomElement(GridLayer gridLayer, GridWidget gridWidget) {
        this.widget = (Widget)this.createWidget();
        this.e = this.createDomElementInternal(this.widget, gridLayer, gridWidget);
        return this.e;
    }

    @Override
    public void registerHandlers(W widget, E widgetDomElement) {
        widget.addDomHandler((EventHandler)this.destroyOrFlushKeyDownHandler(), KeyDownEvent.getType());
        widget.addDomHandler((EventHandler)((KeyDownHandler)e -> e.stopPropagation()), KeyDownEvent.getType());
        widget.addDomHandler((EventHandler)((MouseDownHandler)e -> e.stopPropagation()), MouseDownEvent.getType());
        if (widget instanceof Focusable) {
            widget.addDomHandler((EventHandler)((BlurHandler)e -> {
                this.flush();
                this.gridLayer.batch();
                this.gridPanel.setFocus(true);
            }), BlurEvent.getType());
        }
    }

    @Override
    public void destroyResources() {
        if (this.e != null) {
            ((BaseDOMElement)this.e).detach();
            this.widget = null;
            this.e = null;
        }
    }

    @Override
    public void flush() {
        if (this.e != null) {
            if (this.widget != null) {
                ((BaseDOMElement)this.e).flush(this.getValue());
            }
            ((BaseDOMElement)this.e).detach();
            this.widget = null;
            this.e = null;
        }
    }

    protected KeyDownHandlerCommon destroyOrFlushKeyDownHandler() {
        return new KeyDownHandlerCommon(this.gridPanel, this.gridLayer, this.gridWidget, this);
    }

    protected abstract T getValue();

    protected abstract E createDomElementInternal(W var1, GridLayer var2, GridWidget var3);
}

