/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPathClipper;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.impl.BoundingBoxPathClipperFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public class ColumnRenderingStrategyFlattened {
    public static List<GridRenderer.RendererCommand> render(GridColumn<?> column, GridBodyColumnRenderContext context, BaseGridRendererHelper rendererHelper, BaseGridRendererHelper.RenderingInformation renderingInformation, BiFunction<Boolean, GridColumn<?>, Boolean> columnRenderingConstraint) {
        double x = context.getX();
        double absoluteGridY = context.getAbsoluteGridY();
        double absoluteColumnX = context.getAbsoluteColumnX();
        double clipMinY = context.getClipMinY();
        double clipMinX = context.getClipMinX();
        int minVisibleRowIndex = context.getMinVisibleRowIndex();
        int maxVisibleRowIndex = context.getMaxVisibleRowIndex();
        List<Double> allRowHeights = renderingInformation.getAllRowHeights();
        List<Double> visibleRowOffsets = renderingInformation.getVisibleRowOffsets();
        boolean isFloating = context.isFloating();
        GridData model = context.getModel();
        Transform transform = context.getTransform();
        GridRenderer renderer = context.getRenderer();
        GridRendererTheme theme = renderer.getTheme();
        double columnWidth = column.getWidth();
        double columnHeight = visibleRowOffsets.get(maxVisibleRowIndex - minVisibleRowIndex) - visibleRowOffsets.get(0) + allRowHeights.get(maxVisibleRowIndex);
        ArrayList<GridRenderer.RendererCommand> commands = new ArrayList<GridRenderer.RendererCommand>();
        commands.add(rc -> {
            if (!rc.isSelectionLayer()) {
                MultiPath bodyGrid = theme.getBodyGridLine();
                for (int rowIndex = minVisibleRowIndex; rowIndex <= maxVisibleRowIndex; ++rowIndex) {
                    if (rowIndex == 0) continue;
                    double y = (Double)visibleRowOffsets.get(rowIndex - minVisibleRowIndex) - (Double)visibleRowOffsets.get(0);
                    bodyGrid.M(x, y + 0.5).L(x + columnWidth, y + 0.5);
                }
                int columnIndex = model.getColumns().indexOf(column);
                if (columnIndex < model.getColumnCount() - 1) {
                    bodyGrid.M(x + columnWidth + 0.5, 0.0).L(x + columnWidth + 0.5, columnHeight);
                }
                rc.getGroup().add((IPrimitive)bodyGrid);
            }
        });
        commands.add(rc -> {
            if (((Boolean)columnRenderingConstraint.apply(rc.isSelectionLayer(), column)).booleanValue()) {
                Group columnGroup = (Group)GWT.create(Group.class);
                columnGroup.setX(x);
                int columnIndex = model.getColumns().indexOf(column);
                for (int rowIndex = minVisibleRowIndex; rowIndex <= maxVisibleRowIndex; ++rowIndex) {
                    double y = (Double)visibleRowOffsets.get(rowIndex - minVisibleRowIndex) - (Double)visibleRowOffsets.get(0);
                    double rowHeight = (Double)allRowHeights.get(rowIndex);
                    GridBodyCellRenderContext cellContext = new GridBodyCellRenderContext(absoluteColumnX, absoluteGridY + renderer.getHeaderHeight() + (Double)visibleRowOffsets.get(rowIndex - minVisibleRowIndex), columnWidth, rowHeight, clipMinY, clipMinX, rowIndex, columnIndex, isFloating, transform, renderer);
                    GridCell<?> cell = model.getCell(rowIndex, columnIndex);
                    Group cc = column.getColumnRenderer().renderCell(cell, cellContext);
                    if (cc == null) continue;
                    ((Group)((Group)cc.setX(0.0)).setY(y)).setListening(true);
                    columnGroup.add((IPrimitive)cc);
                }
                BoundingBoxPathClipperFactory boundingBoxPathClipperFactory = (BoundingBoxPathClipperFactory)GWT.create(BoundingBoxPathClipperFactory.class);
                IPathClipper clipper = boundingBoxPathClipperFactory.newClipper(0.0, 0.0, columnWidth, columnHeight);
                columnGroup.setPathClipper(clipper);
                clipper.setActive(true);
                rc.getGroup().add((IPrimitive)columnGroup);
            }
        });
        return commands;
    }
}

