/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.model.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;

public class BaseGridRow
implements GridRow {
    protected double height = 20.0;
    protected Map<Integer, GridCell<?>> cells = new HashMap();
    private boolean hasMergedCells = false;
    private Stack<Double> heights = new Stack();
    private int collapseLevel = 0;

    public BaseGridRow() {
        this(20.0);
    }

    public BaseGridRow(double height) {
        this.height = height;
        this.heights.push(height);
    }

    @Override
    public Map<Integer, GridCell<?>> getCells() {
        return Collections.unmodifiableMap(this.cells);
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double height) {
        this.height = height;
    }

    @Override
    public double peekHeight() {
        return this.heights.peek();
    }

    @Override
    public boolean isMerged() {
        return this.hasMergedCells;
    }

    @Override
    public boolean isCollapsed() {
        return this.collapseLevel > 0;
    }

    @Override
    public void collapse() {
        ++this.collapseLevel;
        this.heights.push(this.height);
        for (GridCell<?> cell : this.cells.values()) {
            cell.collapse();
        }
    }

    @Override
    public void expand() {
        if (this.collapseLevel == 0) {
            return;
        }
        --this.collapseLevel;
        this.height = this.heights.pop();
        for (GridCell<?> cell : this.cells.values()) {
            cell.expand();
        }
    }

    @Override
    public void reset() {
        this.collapseLevel = 0;
        this.hasMergedCells = false;
        this.height = (Double)this.heights.firstElement();
        this.heights.clear();
        this.heights.push(this.height);
        for (GridCell<?> cell : this.cells.values()) {
            cell.reset();
        }
    }

    void setCell(int columnIndex, GridCell cell) {
        this.cells.put(columnIndex, cell);
    }

    void deleteCell(int columnIndex) {
        this.cells.remove(columnIndex);
    }

    void setHasMergedCells(boolean hasMergedCells) {
        this.hasMergedCells = hasMergedCells;
    }
}

