/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.dnd;

import com.ait.lienzo.client.core.event.NodeMouseDownEvent;
import com.ait.lienzo.client.core.event.NodeMouseDownHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.shared.core.types.DragMode;
import com.google.gwt.dom.client.Style;
import java.util.List;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDProxy;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public class GridWidgetDnDMouseDownHandler
implements NodeMouseDownHandler {
    protected final GridLayer layer;
    protected final GridWidgetDnDHandlersState state;

    public GridWidgetDnDMouseDownHandler(GridLayer layer, GridWidgetDnDHandlersState state) {
        this.layer = layer;
        this.state = state;
    }

    public void onNodeMouseDown(NodeMouseDownEvent event) {
        if (this.state.getActiveGridWidget() == null) {
            return;
        }
        GridWidget activeGridWidget = this.state.getActiveGridWidget();
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate(activeGridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        switch (this.state.getOperation()) {
            case COLUMN_RESIZE_PENDING: {
                if (this.state.getActiveGridColumns().isEmpty()) {
                    return;
                }
                this.state.setEventInitialX(ap.getX());
                this.state.setEventInitialColumnWidth(this.state.getActiveGridColumns().get(0).getWidth());
                this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_RESIZE);
                break;
            }
            case COLUMN_MOVE_PENDING: {
                if (this.state.getActiveGridColumns().isEmpty()) {
                    return;
                }
                this.state.setEventInitialX(ap.getX());
                this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.COLUMN_MOVE_INITIATED);
                this.showColumnHighlight(this.state.getActiveGridWidget(), this.state.getActiveGridColumns());
                break;
            }
            case ROW_MOVE_PENDING: {
                if (this.state.getActiveGridRows().isEmpty()) {
                    return;
                }
                this.state.setEventInitialX(ap.getX());
                this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.ROW_MOVE_INITIATED);
                this.showRowHighlight(this.state.getActiveGridWidget(), this.state.getActiveGridRows());
                break;
            }
            case GRID_MOVE_PENDING: {
                this.state.setOperation(GridWidgetDnDHandlersState.GridWidgetHandlersOperation.GRID_MOVE);
                activeGridWidget.setDragMode(DragMode.SAME_LAYER);
                activeGridWidget.setDraggable(true);
                this.setCursor(Style.Cursor.MOVE);
            }
        }
    }

    private void setCursor(Style.Cursor cursor) {
        this.layer.getViewport().getElement().getStyle().setCursor(cursor);
        this.state.setCursor(cursor);
    }

    protected void showColumnHighlight(GridWidget view, List<GridColumn<?>> activeGridColumns) {
        BaseGridRendererHelper rendererHelper = view.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return;
        }
        Group header = view.getHeader();
        double headerRowsYOffset = renderingInformation.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        Bounds bounds = renderingInformation.getBounds();
        double activeColumnX = rendererHelper.getColumnOffset(activeGridColumns.get(0));
        double highlightWidth = this.getHighlightWidth(activeGridColumns);
        double highlightHeight = this.getHighlightHeight(bounds, view, headerMinY);
        GridWidgetDnDProxy highlight = this.state.getEventColumnHighlight();
        highlight.setWidth(highlightWidth);
        highlight.setHeight(highlightHeight);
        highlight.setX(view.getComputedLocation().getX() + activeColumnX);
        highlight.setY(view.getComputedLocation().getY() + headerMinY);
        this.layer.add((Object)this.state.getEventColumnHighlight());
        this.layer.getLayer().batch();
    }

    private double getHighlightWidth(List<GridColumn<?>> activeGridColumns) {
        double highlightWidth = 0.0;
        for (GridColumn<?> activeGridColumn : activeGridColumns) {
            highlightWidth += activeGridColumn.getWidth();
        }
        return highlightWidth;
    }

    private double getHighlightHeight(Bounds bounds, GridWidget view, double headerMinY) {
        double highlightHeight = Math.min(bounds.getY() + bounds.getHeight() - view.getComputedLocation().getY(), view.getHeight()) - headerMinY;
        return highlightHeight;
    }

    protected void showRowHighlight(GridWidget view, List<GridRow> activeGridRows) {
        BaseGridRendererHelper rendererHelper = view.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation renderingInformation = rendererHelper.getRenderingInformation();
        if (renderingInformation == null) {
            return;
        }
        Bounds bounds = renderingInformation.getBounds();
        GridRow row = activeGridRows.get(0);
        int rowIndex = view.getModel().getRows().indexOf(row);
        List<Double> allRowHeights = renderingInformation.getAllRowHeights();
        double rowOffsetY = rendererHelper.getRowOffset(rowIndex, allRowHeights) + view.getRenderer().getHeaderHeight();
        double highlightWidth = Math.min(bounds.getX() + bounds.getWidth() - view.getComputedLocation().getX(), view.getWidth());
        double highlightHeight = allRowHeights.get(rowIndex);
        GridWidgetDnDProxy highlight = this.state.getEventColumnHighlight();
        highlight.setWidth(highlightWidth);
        highlight.setHeight(highlightHeight);
        highlight.setX(view.getComputedLocation().getX());
        highlight.setY(view.getComputedLocation().getY() + rowOffsetY);
        this.layer.add((Object)this.state.getEventColumnHighlight());
        this.layer.getLayer().batch();
    }
}

