/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.dom.multiple.impl;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.impl.BaseDOMElement;
import org.uberfire.ext.wires.core.grids.client.widget.dom.multiple.MultipleDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public abstract class BaseDOMElementFactory<T, W extends Widget, E extends BaseDOMElement<T, W>>
implements MultipleDOMElementFactory<W, E> {
    protected final GridLayer gridLayer;
    protected final GridWidget gridWidget;
    protected final List<E> domElements = new ArrayList();
    private int consumed = 0;

    public BaseDOMElementFactory(GridLayer gridLayer, GridWidget gridWidget) {
        this.gridLayer = gridLayer;
        this.gridWidget = gridWidget;
    }

    @Override
    public void attachDomElement(GridBodyCellRenderContext context, Consumer<E> onCreation, Consumer<E> onDisplay) {
        BaseDOMElement domElement;
        if (this.consumed + 1 > this.domElements.size()) {
            domElement = (BaseDOMElement)this.createDomElement(this.gridLayer, this.gridWidget);
            this.domElements.add(domElement);
        } else {
            domElement = (BaseDOMElement)this.domElements.get(this.consumed);
        }
        ++this.consumed;
        domElement.setContext(context);
        domElement.initialise(context);
        onCreation.accept(domElement);
        domElement.attach();
        onDisplay.accept(domElement);
    }

    @Override
    public void initialiseResources() {
        this.consumed = 0;
    }

    @Override
    public void destroyResources() {
        for (BaseDOMElement domElement : this.domElements) {
            domElement.detach();
        }
        this.domElements.clear();
        this.consumed = 0;
    }

    @Override
    public void freeUnusedResources() {
        ArrayList<BaseDOMElement> freedDomElements = new ArrayList<BaseDOMElement>();
        for (int i = this.consumed; i < this.domElements.size(); ++i) {
            BaseDOMElement domElement = (BaseDOMElement)this.domElements.get(i);
            domElement.detach();
            freedDomElements.add(domElement);
        }
        for (BaseDOMElement domElement : freedDomElements) {
            this.domElements.remove(domElement);
        }
    }
}

