/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.keyboard;

import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.HasSingletonDOMElementResource;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

public class KeyDownHandlerCommon
implements KeyDownHandler {
    protected final GridLienzoPanel gridPanel;
    protected final GridLayer gridLayer;
    protected final GridWidget gridWidget;
    protected final HasSingletonDOMElementResource gridCell;
    private final boolean isTabKeyHandled;
    private final boolean isEnterKeyHandled;
    private final boolean isEscapeKeyHandled;

    public KeyDownHandlerCommon(GridLienzoPanel gridPanel, GridLayer gridLayer, GridWidget gridWidget, HasSingletonDOMElementResource gridCell) {
        this(gridPanel, gridLayer, gridWidget, gridCell, true, true, true);
    }

    public KeyDownHandlerCommon(GridLienzoPanel gridPanel, GridLayer gridLayer, GridWidget gridWidget, HasSingletonDOMElementResource gridCell, boolean isTabKeyHandled, boolean isEnterKeyHandled, boolean isEscapeKeyHandled) {
        this.gridPanel = gridPanel;
        this.gridLayer = gridLayer;
        this.gridWidget = gridWidget;
        this.gridCell = gridCell;
        this.isTabKeyHandled = isTabKeyHandled;
        this.isEnterKeyHandled = isEnterKeyHandled;
        this.isEscapeKeyHandled = isEscapeKeyHandled;
    }

    public void onKeyDown(KeyDownEvent e) {
        int keyCode = e.getNativeKeyCode();
        switch (keyCode) {
            case 9: {
                if (!this.isTabKeyHandled) break;
                this.flush(e);
                break;
            }
            case 13: {
                if (!this.isEnterKeyHandled) break;
                this.flush(e);
                break;
            }
            case 27: {
                if (!this.isEscapeKeyHandled) break;
                this.reset();
            }
        }
        e.stopPropagation();
    }

    private void flush(KeyDownEvent e) {
        int keyCode = e.getNativeKeyCode();
        boolean isShiftKeyDown = e.isShiftKeyDown();
        this.gridCell.flush();
        this.moveSelection(keyCode, isShiftKeyDown);
        e.preventDefault();
        this.reset();
    }

    private void reset() {
        this.gridCell.destroyResources();
        this.gridPanel.setFocus(true);
        this.gridLayer.batch();
    }

    protected void moveSelection(int keyCode, boolean isShiftKeyDown) {
        Optional<Integer> dx = this.getDelta(keyCode, 9, isShiftKeyDown);
        Optional<Integer> dy = this.getDelta(keyCode, 13, isShiftKeyDown);
        if (dx.isPresent()) {
            this.gridWidget.adjustSelection(dx.get() > 0 ? SelectionExtension.RIGHT : SelectionExtension.LEFT, false);
        }
        if (dy.isPresent()) {
            this.gridWidget.adjustSelection(dy.get() > 0 ? SelectionExtension.DOWN : SelectionExtension.UP, false);
        }
    }

    private Optional<Integer> getDelta(int keyCode, int requiredKeyCode, boolean isShiftKeyDown) {
        if (keyCode == requiredKeyCode) {
            return Optional.of(isShiftKeyDown ? -1 : 1);
        }
        return Optional.empty();
    }
}

