/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.grids.client.widget.grid.impl;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import java.util.Optional;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.NodeMouseEventHandler;

public abstract class BaseGridWidgetMouseEventHandler {
    protected GridWidget gridWidget;
    protected List<NodeMouseEventHandler> handlers;

    public BaseGridWidgetMouseEventHandler(GridWidget gridWidget, List<NodeMouseEventHandler> handlers) {
        this.gridWidget = gridWidget;
        this.handlers = handlers;
    }

    public void doEventDispatch(AbstractNodeMouseEvent event) {
        if (!this.gridWidget.isVisible()) {
            return;
        }
        Point2D relativeLocation = CoordinateUtilities.convertDOMToGridCoordinate(this.gridWidget, new Point2D((double)event.getX(), (double)event.getY()));
        Integer uiHeaderRowIndex = CoordinateUtilities.getUiHeaderRowIndex(this.gridWidget, relativeLocation);
        Integer uiHeaderColumnIndex = CoordinateUtilities.getUiColumnIndex(this.gridWidget, relativeLocation.getX());
        Integer uiRowIndex = CoordinateUtilities.getUiRowIndex(this.gridWidget, relativeLocation.getY());
        Integer uiColumnIndex = CoordinateUtilities.getUiColumnIndex(this.gridWidget, relativeLocation.getX());
        this.handlers.stream().forEach(handler -> handler.onNodeMouseEvent(this.gridWidget, relativeLocation, Optional.ofNullable(uiHeaderRowIndex), Optional.ofNullable(uiHeaderColumnIndex), Optional.ofNullable(uiRowIndex), Optional.ofNullable(uiColumnIndex), event));
    }
}

