/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.shapes.fixed;

import com.ait.lienzo.client.core.event.NodeDragEndEvent;
import com.ait.lienzo.client.core.event.NodeDragEndHandler;
import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveHandler;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickEvent;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.wires.core.api.containers.ContainerManager;
import org.uberfire.ext.wires.core.api.containers.RequiresContainerManager;
import org.uberfire.ext.wires.core.api.containers.WiresContainer;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;

public class WiresFixedText
extends WiresBaseShape
implements RequiresContainerManager {
    private static final int BOUNDARY_SIZE = 10;
    private static final double ALPHA_DESELECTED = 0.01;
    private static final double ALPHA_SELECTED = 0.1;
    private final Text text;
    private final Text bounding;
    private final TextBox editTextBox = new TextBox();
    private WiresContainer boundContainer;
    protected ContainerManager containerManager;

    public WiresFixedText(Text shape) {
        this.text = shape;
        this.text.setText("Text");
        this.bounding = new Text(this.text.getText(), this.text.getFontFamily(), this.text.getFontSize());
        this.bounding.setTextBaseLine(this.text.getTextBaseLine());
        this.bounding.setTextAlign(this.text.getTextAlign());
        this.bounding.setStrokeWidth(10.0);
        this.bounding.setAlpha(0.01);
        this.add((IPrimitive)this.text);
        this.add((IPrimitive)this.bounding);
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                WiresFixedText.this.boundContainer = WiresFixedText.this.containerManager.getContainer(WiresFixedText.this.getX(), WiresFixedText.this.getY());
                if (WiresFixedText.this.boundContainer != null) {
                    WiresFixedText.this.boundContainer.detachShape((WiresBaseShape)WiresFixedText.this);
                }
                WiresFixedText.this.getLayer().batch();
            }
        });
        this.addNodeDragEndHandler(new NodeDragEndHandler(){

            public void onNodeDragEnd(NodeDragEndEvent nodeDragEndEvent) {
                if (WiresFixedText.this.boundContainer != null) {
                    WiresFixedText.this.boundContainer.attachShape((WiresBaseShape)WiresFixedText.this);
                    WiresFixedText.this.boundContainer.setHover(false);
                }
                WiresFixedText.this.getLayer().batch();
            }
        });
        this.editTextBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                WiresFixedText.this.text.setText(WiresFixedText.this.editTextBox.getText());
                WiresFixedText.this.bounding.setText(WiresFixedText.this.editTextBox.getText());
                WiresFixedText.this.text.getLayer().batch();
                RootPanel.get().remove((Widget)WiresFixedText.this.editTextBox);
            }
        });
        this.editTextBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    WiresFixedText.this.text.setText(WiresFixedText.this.editTextBox.getText());
                    WiresFixedText.this.bounding.setText(WiresFixedText.this.editTextBox.getText());
                    WiresFixedText.this.text.getLayer().batch();
                    RootPanel.get().remove((Widget)WiresFixedText.this.editTextBox);
                }
                if (event.getNativeKeyCode() == 27) {
                    RootPanel.get().remove((Widget)WiresFixedText.this.editTextBox);
                }
            }
        });
        this.addNodeMouseDoubleClickHandler(new NodeMouseDoubleClickHandler(){

            public void onNodeMouseDoubleClick(NodeMouseDoubleClickEvent nodeMouseDoubleClickEvent) {
                WiresFixedText.this.editTextBox.setText(WiresFixedText.this.text.getText());
                WiresFixedText.this.editTextBox.getElement().getStyle().setPosition(Style.Position.FIXED);
                WiresFixedText.this.editTextBox.getElement().getStyle().setLeft(WiresFixedText.this.getX() + (double)WiresFixedText.this.getLayer().getCanvasElement().getAbsoluteLeft(), Style.Unit.PX);
                WiresFixedText.this.editTextBox.getElement().getStyle().setTop(WiresFixedText.this.getY() + (double)WiresFixedText.this.getLayer().getCanvasElement().getAbsoluteTop(), Style.Unit.PX);
                RootPanel.get().add((Widget)WiresFixedText.this.editTextBox);
                WiresFixedText.this.editTextBox.setFocus(true);
            }
        });
    }

    public void setContainerManager(ContainerManager containerManager) {
        this.containerManager = containerManager;
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.bounding.setAlpha(0.1);
        } else {
            this.bounding.setAlpha(0.01);
        }
    }

    public boolean contains(double cx, double cy) {
        return false;
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String text) {
        this.text.setText(text);
        this.bounding.setText(text);
    }

    public TextAlign getTextAlign() {
        return this.text.getTextAlign();
    }

    public void setTextAlign(TextAlign align) {
        this.text.setTextAlign(align);
        this.bounding.setTextAlign(align);
    }

    public String getStrokeColour() {
        return this.text.getStrokeColor();
    }

    public void setStrokeColour(String strokeColour) {
        this.text.setStrokeColor(strokeColour);
    }

    public String getFillColour() {
        return this.text.getFillColor();
    }

    public void setFillColour(String fillColour) {
        this.text.setFillColor(fillColour);
    }

    public double getFontSize() {
        return this.text.getFontSize();
    }

    public void setFontSize(double fontSize) {
        this.text.setFontSize(fontSize);
        this.bounding.setFontSize(fontSize);
    }
}

