/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.properties;

import com.ait.lienzo.shared.core.types.TextAlign;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.wires.core.api.properties.PropertyEditorAdaptor;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.properties.WiresComboPropertyEditorFieldInfo;
import org.uberfire.ext.wires.core.scratchpad.client.properties.CssHexColourValidator;
import org.uberfire.ext.wires.core.scratchpad.client.shapes.fixed.WiresFixedText;

@ApplicationScoped
public class WiresFixedTextPropertyEditorAdaptor
implements PropertyEditorAdaptor {
    private static final String ATTRIBUTES = "Attributes";

    public boolean supports(WiresBaseShape shape) {
        return shape instanceof WiresFixedText;
    }

    public List<PropertyEditorCategory> getProperties(WiresBaseShape shape) {
        if (!this.supports(shape)) {
            return Collections.emptyList();
        }
        final WiresFixedText w = (WiresFixedText)shape;
        PropertyEditorFieldInfo fieldInfo1 = new PropertyEditorFieldInfo("Text", String.valueOf(w.getText()), PropertyEditorType.TEXT){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                w.setText(currentStringValue);
                w.getLayer().batch();
            }
        };
        WiresComboPropertyEditorFieldInfo fieldInfo2 = new WiresComboPropertyEditorFieldInfo("Text Align", w.getTextAlign().getValue(), this.getTextAlignValues()){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                w.setTextAlign(TextAlign.lookup((String)currentStringValue));
                w.getLayer().batch();
            }
        };
        PropertyEditorFieldInfo fieldInfo3 = new PropertyEditorFieldInfo("Stroke colour", String.valueOf(w.getStrokeColour()), PropertyEditorType.TEXT){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                w.setStrokeColour(currentStringValue);
                w.getLayer().batch();
            }
        };
        PropertyEditorFieldInfo fieldInfo4 = new PropertyEditorFieldInfo("Fill colour", String.valueOf(w.getFillColour()), PropertyEditorType.TEXT){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                w.setFillColour(currentStringValue);
                w.getLayer().batch();
            }
        };
        WiresComboPropertyEditorFieldInfo fieldInfo5 = new WiresComboPropertyEditorFieldInfo("Font size", String.valueOf(w.getFontSize()), this.getFontSizeValues()){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                try {
                    double fontSize = Double.parseDouble(currentStringValue);
                    w.setFontSize(fontSize);
                    w.getLayer().batch();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        fieldInfo1.getValidators().clear();
        fieldInfo2.getValidators().clear();
        fieldInfo3.getValidators().clear();
        fieldInfo4.getValidators().clear();
        fieldInfo5.getValidators().clear();
        fieldInfo3.getValidators().add(new CssHexColourValidator());
        fieldInfo4.getValidators().add(new CssHexColourValidator());
        PropertyEditorCategory attributes = new PropertyEditorCategory(ATTRIBUTES).withField(fieldInfo1).withField((PropertyEditorFieldInfo)fieldInfo2).withField(fieldInfo3).withField(fieldInfo4).withField((PropertyEditorFieldInfo)fieldInfo5);
        return Lists.newArrayList((Object[])new PropertyEditorCategory[]{attributes});
    }

    private List<String> getTextAlignValues() {
        ArrayList<String> values = new ArrayList<String>();
        for (TextAlign ta : TextAlign.values()) {
            values.add(ta.getValue());
        }
        return values;
    }

    private List<String> getFontSizeValues() {
        return Arrays.asList("15", "20", "25", "30", "35", "40", "45", "50");
    }
}

