/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.shapes.containers;

import com.ait.lienzo.client.core.shape.Circle;
import com.ait.lienzo.client.core.shape.IPrimitive;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPointMoveHandler;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseDynamicContainer;
import org.uberfire.ext.wires.core.client.controlpoints.DefaultControlPoint;
import org.uberfire.ext.wires.core.client.magnets.DefaultMagnet;

public class WiresCircularContainer
extends WiresBaseDynamicContainer {
    private static final int BOUNDARY_SIZE = 10;
    private final Circle circle;
    private final Circle bounding;
    private final String circleStrokeColour;
    private final String circleFillColour;
    private final Magnet magnet1;
    private final Magnet magnet2;
    private final Magnet magnet3;
    private final Magnet magnet4;
    private final ControlPoint controlPoint1;

    public WiresCircularContainer(Circle shape) {
        this.circle = shape;
        this.circleFillColour = shape.getFillColor();
        this.circleStrokeColour = shape.getStrokeColor();
        double radius = this.circle.getRadius();
        this.bounding = new Circle(radius + 5.0);
        this.bounding.setStrokeWidth(10.0);
        this.bounding.setAlpha(0.1);
        this.add((IPrimitive)this.circle);
        this.magnets.clear();
        this.magnet1 = new DefaultMagnet(this.getX() - radius, this.getY());
        this.magnet2 = new DefaultMagnet(this.getX() + radius, this.getY());
        this.magnet3 = new DefaultMagnet(this.getX(), this.getY() - radius);
        this.magnet4 = new DefaultMagnet(this.getX(), this.getY() + radius);
        this.addMagnet(this.magnet1);
        this.addMagnet(this.magnet2);
        this.addMagnet(this.magnet3);
        this.addMagnet(this.magnet4);
        this.controlPoints.clear();
        this.controlPoint1 = new DefaultControlPoint(this.getX() + radius, this.getY(), new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                double dx = WiresCircularContainer.this.getX() - x;
                double dy = WiresCircularContainer.this.getY() - y;
                double r = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                WiresCircularContainer.this.magnet1.setX(WiresCircularContainer.this.getX() - r);
                WiresCircularContainer.this.magnet2.setX(WiresCircularContainer.this.getX() + r);
                WiresCircularContainer.this.magnet3.setY(WiresCircularContainer.this.getY() - r);
                WiresCircularContainer.this.magnet4.setY(WiresCircularContainer.this.getY() + r);
                WiresCircularContainer.this.circle.setRadius(r);
                WiresCircularContainer.this.bounding.setRadius(r + 5.0);
            }
        });
        this.addControlPoint(this.controlPoint1);
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.add((IPrimitive)this.bounding);
        } else {
            this.remove((IPrimitive)this.bounding);
        }
    }

    public boolean contains(double cx, double cy) {
        double _x = cx - this.getX();
        double _y = cy - this.getY();
        return Math.sqrt(Math.pow(_x, 2.0) + Math.pow(_y, 2.0)) < this.circle.getRadius() + 10.0;
    }

    public void setHover(boolean isHover) {
        if (isHover) {
            this.circle.setFillColor("#33FF33");
            this.circle.setStrokeColor("#33CC33");
        } else {
            this.circle.setFillColor(this.circleFillColour);
            this.circle.setStrokeColor(this.circleStrokeColour);
        }
    }

    public String toString() {
        return "WiresCircularContainer{id=" + this.getId() + ",x = " + this.getX() + ", y = " + this.getY() + "}";
    }
}

