/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.properties;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.ext.properties.editor.model.validators.PropertyFieldValidator;

@ApplicationScoped
public class CssHexColourValidator
implements PropertyFieldValidator {
    private static final List<Character> HEX_DIGITS = Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'));

    public boolean validate(Object value) {
        String hex = value.toString().toLowerCase();
        if (hex.length() != 7) {
            return false;
        }
        if (!hex.startsWith("#")) {
            return false;
        }
        char[] arr$ = hex.substring(1).toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (HEX_DIGITS.contains(c)) continue;
            return false;
        }
        return true;
    }

    public String getValidatorErrorMessage() {
        return "Value must be a CSS colour #rrggbb.";
    }
}

