/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.shapes.connectors;

import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveHandler;
import com.ait.lienzo.client.core.shape.Arrow;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.shared.core.types.ArrowType;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPointMoveHandler;
import org.uberfire.ext.wires.core.api.controlpoints.HasControlPoints;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.api.magnets.MagnetManager;
import org.uberfire.ext.wires.core.api.magnets.RequiresMagnetManager;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseDynamicShape;
import org.uberfire.ext.wires.core.api.shapes.WiresShape;
import org.uberfire.ext.wires.core.client.controlpoints.ConnectibleControlPoint;
import org.uberfire.ext.wires.core.client.util.GeometryUtil;

public class WiresArrow
extends WiresBaseDynamicShape
implements MagnetManager,
RequiresMagnetManager {
    private static final int BOUNDARY_SIZE = 10;
    private static final int BASE_WIDTH = 10;
    private static final int HEAD_WIDTH = 20;
    private static final int ARROW_ANGLE = 45;
    private static final int BASE_ANGLE = 30;
    private final Arrow arrow;
    private final Arrow bounding;
    private final ConnectibleControlPoint controlPoint1;
    private final ConnectibleControlPoint controlPoint2;
    private MagnetManager magnetManager;

    public WiresArrow(Arrow shape) {
        double x1 = shape.getStart().getX();
        double y1 = shape.getStart().getY();
        double x2 = shape.getEnd().getX();
        double y2 = shape.getEnd().getY();
        this.arrow = shape;
        this.bounding = new Arrow(new Point2D(x1, y1), new Point2D(x2, y2), 10.0, 20.0, 45.0, 30.0, ArrowType.AT_END);
        this.bounding.setStrokeWidth(10.0);
        this.bounding.setAlpha(0.1);
        this.add((IPrimitive)this.arrow);
        this.magnets.clear();
        this.controlPoints.clear();
        this.controlPoint1 = new ConnectibleControlPoint(x1, y1, (HasControlPoints)this, (MagnetManager)this, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresArrow.this.arrow.setStart(new Point2D(x - WiresArrow.this.getX(), y - WiresArrow.this.getY()));
                WiresArrow.this.bounding.setStart(new Point2D(x - WiresArrow.this.getX(), y - WiresArrow.this.getY()));
            }
        });
        this.controlPoint2 = new ConnectibleControlPoint(x2, y2, (HasControlPoints)this, (MagnetManager)this, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresArrow.this.arrow.setEnd(new Point2D(x - WiresArrow.this.getX(), y - WiresArrow.this.getY()));
                WiresArrow.this.bounding.setEnd(new Point2D(x - WiresArrow.this.getX(), y - WiresArrow.this.getY()));
            }
        });
        this.addControlPoint((ControlPoint)this.controlPoint1);
        this.addControlPoint((ControlPoint)this.controlPoint2);
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                Magnet boundMagnet1 = WiresArrow.this.controlPoint1.getBoundMagnet();
                Magnet boundMagnet2 = WiresArrow.this.controlPoint2.getBoundMagnet();
                if (boundMagnet1 != null) {
                    boundMagnet1.detachControlPoint((ControlPoint)WiresArrow.this.controlPoint1);
                }
                if (boundMagnet2 != null) {
                    boundMagnet2.detachControlPoint((ControlPoint)WiresArrow.this.controlPoint2);
                }
                WiresArrow.this.getLayer().batch();
            }
        });
    }

    public void setMagnetManager(MagnetManager magnetManager) {
        this.magnetManager = magnetManager;
    }

    public void hideAllMagnets() {
        if (this.magnetManager != null) {
            this.magnetManager.hideAllMagnets();
        }
    }

    public Magnet getMagnet(WiresShape shapeActive, double cx, double cy) {
        if (this.magnetManager != null) {
            return this.magnetManager.getMagnet(shapeActive, cx, cy);
        }
        return null;
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.add((IPrimitive)this.bounding);
        } else {
            this.remove((IPrimitive)this.bounding);
        }
    }

    public boolean contains(double cx, double cy) {
        double _x = cx - this.getX();
        double _y = cy - this.getY();
        return Math.sqrt(GeometryUtil.ptSegDistSq((double)this.arrow.getPoints().get(0).getX(), (double)this.arrow.getPoints().get(0).getY(), (double)this.arrow.getPoints().get(1).getX(), (double)this.arrow.getPoints().get(1).getY(), (double)_x, (double)_y)) < 10.0;
    }

    public String toString() {
        return "WiresArrow{id=" + this.getId() + ",x = " + this.getX() + ", y = " + this.getY() + "}";
    }
}

