/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.properties;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.wires.core.api.properties.PropertyEditorAdaptor;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.properties.DoubleValidator;
import org.uberfire.ext.wires.core.scratchpad.client.shapes.dynamic.WiresRectangle;

@ApplicationScoped
public class WiresRectanglePropertyEditorAdaptor
implements PropertyEditorAdaptor {
    private static final String ATTRIBUTES = "Attributes";

    public boolean supports(WiresBaseShape shape) {
        return shape instanceof WiresRectangle;
    }

    public List<PropertyEditorCategory> getProperties(WiresBaseShape shape) {
        if (!this.supports(shape)) {
            return Collections.emptyList();
        }
        final WiresRectangle w = (WiresRectangle)shape;
        PropertyEditorFieldInfo fieldInfo1 = new PropertyEditorFieldInfo("Width", String.valueOf(w.getWidth()), PropertyEditorType.NATURAL_NUMBER){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                try {
                    double width = Double.parseDouble(currentStringValue);
                    w.setWidth(width);
                    w.getLayer().batch();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        PropertyEditorFieldInfo fieldInfo2 = new PropertyEditorFieldInfo("Height", String.valueOf(w.getHeight()), PropertyEditorType.NATURAL_NUMBER){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                try {
                    double height = Double.parseDouble(currentStringValue);
                    w.setHeight(height);
                    w.getLayer().batch();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        fieldInfo1.getValidators().clear();
        fieldInfo2.getValidators().clear();
        fieldInfo1.getValidators().add(new DoubleValidator());
        fieldInfo2.getValidators().add(new DoubleValidator());
        PropertyEditorCategory attributes = new PropertyEditorCategory(ATTRIBUTES).withField(fieldInfo1).withField(fieldInfo2);
        return Lists.newArrayList((Object[])new PropertyEditorCategory[]{attributes});
    }
}

