/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.shapes.connectors;

import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveHandler;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Line;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPointMoveHandler;
import org.uberfire.ext.wires.core.api.controlpoints.HasControlPoints;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.api.magnets.MagnetManager;
import org.uberfire.ext.wires.core.api.magnets.RequiresMagnetManager;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseDynamicShape;
import org.uberfire.ext.wires.core.api.shapes.WiresShape;
import org.uberfire.ext.wires.core.client.controlpoints.ConnectibleControlPoint;
import org.uberfire.ext.wires.core.client.util.GeometryUtil;

public class WiresLine
extends WiresBaseDynamicShape
implements MagnetManager,
RequiresMagnetManager {
    private static final int BOUNDARY_SIZE = 10;
    private static final double ALPHA_DESELECTED = 0.01;
    private static final double ALPHA_SELECTED = 0.1;
    private final Line line;
    private final Line bounding;
    private final ConnectibleControlPoint controlPoint1;
    private final ConnectibleControlPoint controlPoint2;
    private MagnetManager magnetManager;

    public WiresLine(Line shape) {
        double x1 = shape.getPoints().get(0).getX();
        double y1 = shape.getPoints().get(0).getY();
        double x2 = shape.getPoints().get(1).getX();
        double y2 = shape.getPoints().get(1).getY();
        this.line = shape;
        this.bounding = new Line(x1, y1, x2, y2);
        this.bounding.setStrokeWidth(10.0);
        this.bounding.setAlpha(0.01);
        this.add((IPrimitive)this.line);
        this.add((IPrimitive)this.bounding);
        this.magnets.clear();
        this.controlPoints.clear();
        this.controlPoint1 = new ConnectibleControlPoint(x1, y1, (HasControlPoints)this, (MagnetManager)this, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresLine.this.line.getPoints().get(0).setX(x - WiresLine.this.getX());
                WiresLine.this.line.getPoints().get(0).setY(y - WiresLine.this.getY());
                WiresLine.this.bounding.getPoints().get(0).setX(x - WiresLine.this.getX());
                WiresLine.this.bounding.getPoints().get(0).setY(y - WiresLine.this.getY());
            }
        });
        this.controlPoint2 = new ConnectibleControlPoint(x2, y2, (HasControlPoints)this, (MagnetManager)this, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresLine.this.line.getPoints().get(1).setX(x - WiresLine.this.getX());
                WiresLine.this.line.getPoints().get(1).setY(y - WiresLine.this.getY());
                WiresLine.this.bounding.getPoints().get(1).setX(x - WiresLine.this.getX());
                WiresLine.this.bounding.getPoints().get(1).setY(y - WiresLine.this.getY());
            }
        });
        this.addControlPoint((ControlPoint)this.controlPoint1);
        this.addControlPoint((ControlPoint)this.controlPoint2);
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                Magnet boundMagnet1 = WiresLine.this.controlPoint1.getBoundMagnet();
                Magnet boundMagnet2 = WiresLine.this.controlPoint2.getBoundMagnet();
                if (boundMagnet1 != null) {
                    boundMagnet1.detachControlPoint((ControlPoint)WiresLine.this.controlPoint1);
                }
                if (boundMagnet2 != null) {
                    boundMagnet2.detachControlPoint((ControlPoint)WiresLine.this.controlPoint2);
                }
                WiresLine.this.getLayer().batch();
            }
        });
    }

    public void setMagnetManager(MagnetManager magnetManager) {
        this.magnetManager = magnetManager;
    }

    public void hideAllMagnets() {
        if (this.magnetManager != null) {
            this.magnetManager.hideAllMagnets();
        }
    }

    public Magnet getMagnet(WiresShape shapeActive, double cx, double cy) {
        if (this.magnetManager != null) {
            return this.magnetManager.getMagnet(shapeActive, cx, cy);
        }
        return null;
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.bounding.setAlpha(0.1);
        } else {
            this.bounding.setAlpha(0.01);
        }
    }

    public boolean contains(double cx, double cy) {
        double _x = cx - this.getX();
        double _y = cy - this.getY();
        return Math.sqrt(GeometryUtil.ptSegDistSq((double)this.line.getPoints().get(0).getX(), (double)this.line.getPoints().get(0).getY(), (double)this.line.getPoints().get(1).getX(), (double)this.line.getPoints().get(1).getY(), (double)_x, (double)_y)) < 10.0;
    }

    public String toString() {
        return "WiresLine{id=" + this.getId() + ",x = " + this.getX() + ", y = " + this.getY() + "}";
    }
}

