/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.canvas;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.wires.core.api.containers.ContainerManager;
import org.uberfire.ext.wires.core.api.containers.RequiresContainerManager;
import org.uberfire.ext.wires.core.api.containers.WiresContainer;
import org.uberfire.ext.wires.core.api.events.ClearEvent;
import org.uberfire.ext.wires.core.api.events.ShapeAddedEvent;
import org.uberfire.ext.wires.core.api.events.ShapeDeletedEvent;
import org.uberfire.ext.wires.core.api.events.ShapeDragCompleteEvent;
import org.uberfire.ext.wires.core.api.events.ShapeDragPreviewEvent;
import org.uberfire.ext.wires.core.api.events.ShapeSelectedEvent;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.api.shapes.WiresShape;
import org.uberfire.ext.wires.core.client.canvas.WiresCanvas;
import org.uberfire.ext.wires.core.scratchpad.client.canvas.WiresScratchPadDropContext;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="WiresScratchPadScreen")
public class WiresScratchPadScreen
extends WiresCanvas
implements ContainerManager {
    @Inject
    private Event<ClearEvent> clearEvent;
    @Inject
    private Event<ShapeSelectedEvent> shapeSelectedEvent;
    @Inject
    private Event<ShapeAddedEvent> shapeAddedEvent;
    @Inject
    private Event<ShapeDeletedEvent> shapeDeletedEvent;
    private Menus menus;
    private WiresScratchPadDropContext dropContext = new WiresScratchPadDropContext();

    @PostConstruct
    public void setup() {
        this.menus = ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)"Clear grid").respondsWith(new Command(){

            public void execute() {
                WiresScratchPadScreen.this.clear();
            }
        })).endMenu()).newTopLevelMenu("Delete selected").respondsWith(new Command(){

            public void execute() {
                if (WiresScratchPadScreen.this.isShapeSelected()) {
                    WiresScratchPadScreen.this.deleteShape(WiresScratchPadScreen.this.getSelectedShape());
                }
            }
        })).endMenu()).newTopLevelMenu("Clear selection").respondsWith(new Command(){

            public void execute() {
                if (WiresScratchPadScreen.this.isShapeSelected()) {
                    WiresScratchPadScreen.this.clearSelection();
                    ((MenuItem)WiresScratchPadScreen.this.menus.getItems().get(1)).setEnabled(false);
                    ((MenuItem)WiresScratchPadScreen.this.menus.getItems().get(2)).setEnabled(false);
                }
            }
        })).endMenu()).build();
        ((MenuItem)this.menus.getItems().get(0)).setEnabled(false);
        ((MenuItem)this.menus.getItems().get(1)).setEnabled(false);
        ((MenuItem)this.menus.getItems().get(2)).setEnabled(false);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return "Canvas";
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this;
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    public void selectShape(WiresBaseShape shape) {
        this.shapeSelectedEvent.fire((Object)new ShapeSelectedEvent(shape));
    }

    public void onShapeSelected(@Observes ShapeSelectedEvent event) {
        super.selectShape(event.getShape());
        ((MenuItem)this.menus.getItems().get(1)).setEnabled(this.isShapeSelected());
        ((MenuItem)this.menus.getItems().get(2)).setEnabled(this.isShapeSelected());
    }

    public void deselectShape(WiresBaseShape shape) {
        super.deselectShape(shape);
        ((MenuItem)this.menus.getItems().get(1)).setEnabled(this.isShapeSelected());
        ((MenuItem)this.menus.getItems().get(2)).setEnabled(this.isShapeSelected());
    }

    public void onDragPreviewHandler(@Observes ShapeDragPreviewEvent shapeDragPreviewEvent) {
        if (!(shapeDragPreviewEvent.getShape() instanceof RequiresContainerManager)) {
            this.dropContext.setContext(null);
            return;
        }
        double cx = this.getX(shapeDragPreviewEvent.getX());
        double cy = this.getY(shapeDragPreviewEvent.getY());
        WiresContainer container = this.getContainer(cx, cy);
        this.dropContext.setContext(container);
        this.canvasLayer.batch();
    }

    public void onDragCompleteHandler(@Observes ShapeDragCompleteEvent shapeDragCompleteEvent) {
        WiresBaseShape wiresShape = shapeDragCompleteEvent.getShape();
        if (wiresShape == null) {
            return;
        }
        double cx = this.getX(shapeDragCompleteEvent.getX());
        double cy = this.getY(shapeDragCompleteEvent.getY());
        if (cx < 0.0 || cy < 0.0) {
            return;
        }
        if (cx > (double)this.getOffsetWidth() || cy > (double)this.getOffsetHeight()) {
            return;
        }
        wiresShape.setX(cx);
        wiresShape.setY(cy);
        WiresContainer container = this.dropContext.getContext();
        if (container != null) {
            container.attachShape(wiresShape);
            container.setHover(false);
        }
        this.addShape(wiresShape);
        ((MenuItem)this.menus.getItems().get(0)).setEnabled(true);
        this.shapeAddedEvent.fire((Object)new ShapeAddedEvent(wiresShape));
    }

    private double getX(double xShapeEvent) {
        return xShapeEvent - (double)this.getAbsoluteLeft();
    }

    private double getY(double yShapeEvent) {
        return yShapeEvent - (double)this.getAbsoluteTop();
    }

    public void clear() {
        if (Window.confirm((String)"Are you sure to clean the canvas?")) {
            this.clearEvent.fire((Object)new ClearEvent());
        }
    }

    public void onClear(@Observes ClearEvent event) {
        super.clear();
        ((MenuItem)this.menus.getItems().get(0)).setEnabled(false);
        ((MenuItem)this.menus.getItems().get(1)).setEnabled(false);
        ((MenuItem)this.menus.getItems().get(2)).setEnabled(false);
    }

    public void deleteShape(WiresBaseShape shape) {
        if (Window.confirm((String)"Are you sure to remove the selected shape?")) {
            this.shapeDeletedEvent.fire((Object)new ShapeDeletedEvent(shape));
        }
    }

    public void forceDeleteShape(WiresBaseShape shape) {
        this.shapeDeletedEvent.fire((Object)new ShapeDeletedEvent(shape));
    }

    public void onShapeDeleted(@Observes ShapeDeletedEvent event) {
        super.deleteShape(event.getShape());
        ((MenuItem)this.menus.getItems().get(0)).setEnabled(this.getShapesInCanvas().size() > 0);
        ((MenuItem)this.menus.getItems().get(1)).setEnabled(this.isShapeSelected());
        ((MenuItem)this.menus.getItems().get(2)).setEnabled(this.isShapeSelected());
    }

    public void addShape(WiresBaseShape shape) {
        super.addShape(shape);
        if (shape instanceof RequiresContainerManager) {
            ((RequiresContainerManager)shape).setContainerManager((ContainerManager)this);
        }
    }

    public WiresContainer getContainer(double cx, double cy) {
        WiresContainer container = null;
        for (WiresShape ws : this.getShapesInCanvas()) {
            if (!(ws instanceof WiresContainer)) continue;
            WiresContainer wc = (WiresContainer)ws;
            wc.setHover(false);
            if (!wc.contains(cx, cy)) continue;
            wc.setHover(true);
            container = wc;
        }
        return container;
    }
}

