/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.shapes.dynamic;

import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Rectangle;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPointMoveHandler;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.client.controlpoints.DefaultControlPoint;
import org.uberfire.ext.wires.core.client.magnets.DefaultMagnet;
import org.uberfire.ext.wires.core.scratchpad.client.shapes.WiresScratchPadDefaultShape;

public class WiresRectangle
extends WiresScratchPadDefaultShape {
    private static final int BOUNDARY_SIZE = 10;
    private final Rectangle rectangle;
    private final Rectangle bounding;
    private final Magnet magnet1;
    private final Magnet magnet2;
    private final Magnet magnet3;
    private final Magnet magnet4;
    private final ControlPoint controlPoint1;
    private final ControlPoint controlPoint2;
    private final ControlPoint controlPoint3;
    private final ControlPoint controlPoint4;

    public WiresRectangle(Rectangle shape) {
        double x1 = shape.getX();
        double y1 = shape.getY();
        double x2 = shape.getX() + shape.getWidth();
        double y2 = shape.getY() + shape.getHeight();
        double width = Math.abs(x2 - x1);
        double height = Math.abs(y2 - y1);
        this.rectangle = shape;
        this.bounding = new Rectangle(width + 10.0, height + 10.0, this.rectangle.getCornerRadius());
        this.bounding.setX(x1 - 5.0);
        this.bounding.setY(y1 - 5.0);
        this.bounding.setStrokeWidth(10.0);
        this.bounding.setAlpha(0.1);
        this.add((IPrimitive)this.rectangle);
        this.magnets.clear();
        this.magnet1 = new DefaultMagnet(x1, y1 + height / 2.0);
        this.magnet2 = new DefaultMagnet(x2, y1 + height / 2.0);
        this.magnet3 = new DefaultMagnet(x1 + width / 2.0, y1);
        this.magnet4 = new DefaultMagnet(x1 + width / 2.0, y2);
        this.addMagnet(this.magnet1);
        this.addMagnet(this.magnet2);
        this.addMagnet(this.magnet3);
        this.addMagnet(this.magnet4);
        this.controlPoints.clear();
        double px1 = this.rectangle.getX();
        double py1 = this.rectangle.getY();
        this.controlPoint1 = new DefaultControlPoint(px1, py1, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresRectangle.this.controlPoint2.setY(WiresRectangle.this.controlPoint1.getY());
                WiresRectangle.this.controlPoint3.setX(WiresRectangle.this.controlPoint1.getX());
                WiresRectangle.this.rectangle.setX(x - WiresRectangle.this.getX());
                WiresRectangle.this.rectangle.setY(y - WiresRectangle.this.getY());
                WiresRectangle.this.rectangle.setWidth(WiresRectangle.this.controlPoint2.getX() - WiresRectangle.this.controlPoint1.getX());
                WiresRectangle.this.rectangle.setHeight(WiresRectangle.this.controlPoint3.getY() - WiresRectangle.this.controlPoint1.getY());
                WiresRectangle.this.bounding.setX(x - WiresRectangle.this.getX() - 5.0);
                WiresRectangle.this.bounding.setY(y - WiresRectangle.this.getY() - 5.0);
                WiresRectangle.this.bounding.setWidth(WiresRectangle.this.rectangle.getWidth() + 10.0);
                WiresRectangle.this.bounding.setHeight(WiresRectangle.this.rectangle.getHeight() + 10.0);
                WiresRectangle.this.magnet1.setX(x);
                WiresRectangle.this.magnet1.setY(y + WiresRectangle.this.rectangle.getHeight() / 2.0);
                WiresRectangle.this.magnet2.setY(y + WiresRectangle.this.rectangle.getHeight() / 2.0);
                WiresRectangle.this.magnet3.setX(x + WiresRectangle.this.rectangle.getWidth() / 2.0);
                WiresRectangle.this.magnet3.setY(y);
                WiresRectangle.this.magnet4.setX(x + WiresRectangle.this.rectangle.getWidth() / 2.0);
            }
        });
        double px2 = this.rectangle.getX() + this.rectangle.getWidth();
        double py2 = this.rectangle.getY();
        this.controlPoint2 = new DefaultControlPoint(px2, py2, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresRectangle.this.controlPoint1.setY(WiresRectangle.this.controlPoint2.getY());
                WiresRectangle.this.controlPoint4.setX(WiresRectangle.this.controlPoint2.getX());
                WiresRectangle.this.rectangle.setY(y - WiresRectangle.this.getY());
                WiresRectangle.this.rectangle.setWidth(WiresRectangle.this.controlPoint2.getX() - WiresRectangle.this.controlPoint1.getX());
                WiresRectangle.this.rectangle.setHeight(WiresRectangle.this.controlPoint3.getY() - WiresRectangle.this.controlPoint1.getY());
                WiresRectangle.this.bounding.setY(y - WiresRectangle.this.getY() - 5.0);
                WiresRectangle.this.bounding.setWidth(WiresRectangle.this.rectangle.getWidth() + 10.0);
                WiresRectangle.this.bounding.setHeight(WiresRectangle.this.rectangle.getHeight() + 10.0);
                WiresRectangle.this.magnet1.setY(y + WiresRectangle.this.rectangle.getHeight() / 2.0);
                WiresRectangle.this.magnet2.setX(x);
                WiresRectangle.this.magnet2.setY(y + WiresRectangle.this.rectangle.getHeight() / 2.0);
                WiresRectangle.this.magnet3.setX(x - WiresRectangle.this.rectangle.getWidth() / 2.0);
                WiresRectangle.this.magnet3.setY(y);
                WiresRectangle.this.magnet4.setX(x - WiresRectangle.this.rectangle.getWidth() / 2.0);
            }
        });
        double px3 = this.rectangle.getX();
        double py3 = this.rectangle.getY() + this.rectangle.getHeight();
        this.controlPoint3 = new DefaultControlPoint(px3, py3, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresRectangle.this.controlPoint1.setX(WiresRectangle.this.controlPoint3.getX());
                WiresRectangle.this.controlPoint4.setY(WiresRectangle.this.controlPoint3.getY());
                WiresRectangle.this.rectangle.setX(x - WiresRectangle.this.getX());
                WiresRectangle.this.rectangle.setWidth(WiresRectangle.this.controlPoint2.getX() - WiresRectangle.this.controlPoint1.getX());
                WiresRectangle.this.rectangle.setHeight(WiresRectangle.this.controlPoint3.getY() - WiresRectangle.this.controlPoint1.getY());
                WiresRectangle.this.bounding.setX(x - WiresRectangle.this.getX() - 5.0);
                WiresRectangle.this.bounding.setWidth(WiresRectangle.this.rectangle.getWidth() + 10.0);
                WiresRectangle.this.bounding.setHeight(WiresRectangle.this.rectangle.getHeight() + 10.0);
                WiresRectangle.this.magnet1.setX(x);
                WiresRectangle.this.magnet1.setY(y - WiresRectangle.this.rectangle.getHeight() / 2.0);
                WiresRectangle.this.magnet2.setY(y - WiresRectangle.this.rectangle.getHeight() / 2.0);
                WiresRectangle.this.magnet3.setX(x + WiresRectangle.this.rectangle.getWidth() / 2.0);
                WiresRectangle.this.magnet4.setX(x + WiresRectangle.this.rectangle.getWidth() / 2.0);
                WiresRectangle.this.magnet4.setY(y);
            }
        });
        double px4 = this.rectangle.getX() + this.rectangle.getWidth();
        double py4 = this.rectangle.getY() + this.rectangle.getHeight();
        this.controlPoint4 = new DefaultControlPoint(px4, py4, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresRectangle.this.controlPoint2.setX(WiresRectangle.this.controlPoint4.getX());
                WiresRectangle.this.controlPoint3.setY(WiresRectangle.this.controlPoint4.getY());
                WiresRectangle.this.rectangle.setWidth(WiresRectangle.this.controlPoint2.getX() - WiresRectangle.this.controlPoint1.getX());
                WiresRectangle.this.rectangle.setHeight(WiresRectangle.this.controlPoint3.getY() - WiresRectangle.this.controlPoint1.getY());
                WiresRectangle.this.bounding.setWidth(WiresRectangle.this.rectangle.getWidth() + 10.0);
                WiresRectangle.this.bounding.setHeight(WiresRectangle.this.rectangle.getHeight() + 10.0);
                WiresRectangle.this.magnet1.setY(y - WiresRectangle.this.rectangle.getHeight() / 2.0);
                WiresRectangle.this.magnet2.setX(x);
                WiresRectangle.this.magnet2.setY(y - WiresRectangle.this.rectangle.getHeight() / 2.0);
                WiresRectangle.this.magnet3.setX(x - WiresRectangle.this.rectangle.getWidth() / 2.0);
                WiresRectangle.this.magnet4.setX(x - WiresRectangle.this.rectangle.getWidth() / 2.0);
                WiresRectangle.this.magnet4.setY(y);
            }
        });
        this.addControlPoint(this.controlPoint1);
        this.addControlPoint(this.controlPoint2);
        this.addControlPoint(this.controlPoint3);
        this.addControlPoint(this.controlPoint4);
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.add((IPrimitive)this.bounding);
        } else {
            this.remove((IPrimitive)this.bounding);
        }
    }

    public boolean contains(double cx, double cy) {
        double _x = cx - this.getX();
        double _y = cy - this.getY();
        if (_x < this.rectangle.getX()) {
            return false;
        }
        if (_x > this.rectangle.getX() + this.rectangle.getWidth()) {
            return false;
        }
        if (_y < this.rectangle.getY()) {
            return false;
        }
        return !(_y > this.rectangle.getY() + this.rectangle.getHeight());
    }

    public double getWidth() {
        return this.rectangle.getWidth();
    }

    public void setWidth(double width) {
        this.rectangle.setWidth(width);
        this.bounding.setWidth(width + 10.0);
        this.controlPoint2.setX(this.getX() + this.rectangle.getX() + width);
        this.controlPoint4.setX(this.getX() + this.rectangle.getX() + width);
        this.magnet2.setX(this.getX() + this.rectangle.getX() + width);
        this.magnet3.setX(this.getX() + this.rectangle.getX() + width / 2.0);
        this.magnet4.setX(this.getX() + this.rectangle.getX() + width / 2.0);
    }

    public double getHeight() {
        return this.rectangle.getHeight();
    }

    public void setHeight(double height) {
        this.rectangle.setHeight(height);
        this.bounding.setHeight(height + 10.0);
        this.controlPoint3.setY(this.getY() + this.rectangle.getY() + height);
        this.controlPoint4.setY(this.getY() + this.rectangle.getY() + height);
        this.magnet1.setY(this.getY() + this.rectangle.getY() + height / 2.0);
        this.magnet2.setY(this.getY() + this.rectangle.getY() + height / 2.0);
        this.magnet4.setY(this.getY() + this.rectangle.getY() + height);
    }

    public String toString() {
        return "WiresRectangle{id=" + this.getId() + ",x = " + this.getX() + ", y = " + this.getY() + "}";
    }
}

