/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.shapes.connectors;

import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveHandler;
import com.ait.lienzo.client.core.shape.BezierCurve;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Line;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPointMoveHandler;
import org.uberfire.ext.wires.core.api.controlpoints.HasControlPoints;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.api.magnets.MagnetManager;
import org.uberfire.ext.wires.core.api.magnets.RequiresMagnetManager;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseDynamicShape;
import org.uberfire.ext.wires.core.api.shapes.WiresShape;
import org.uberfire.ext.wires.core.client.controlpoints.ConnectibleControlPoint;
import org.uberfire.ext.wires.core.client.controlpoints.DefaultControlPoint;

public class WiresBezierCurve
extends WiresBaseDynamicShape
implements MagnetManager,
RequiresMagnetManager {
    private static final int BOUNDARY_SIZE = 10;
    private static final double ALPHA_DESELECTED = 0.01;
    private static final double ALPHA_SELECTED = 0.1;
    private final BezierCurve curve;
    private final BezierCurve bounding;
    private final Line controlLine1;
    private final Line controlLine2;
    private final ConnectibleControlPoint controlPoint1;
    private final ControlPoint controlPoint2;
    private final ControlPoint controlPoint3;
    private final ConnectibleControlPoint controlPoint4;
    private MagnetManager magnetManager;

    public WiresBezierCurve(BezierCurve shape) {
        double x = shape.getControlPoints().get(0).getX();
        double y = shape.getControlPoints().get(0).getY();
        double controlX1 = shape.getControlPoints().get(1).getX();
        double controlY1 = shape.getControlPoints().get(1).getY();
        double controlX2 = shape.getControlPoints().get(2).getX();
        double controlY2 = shape.getControlPoints().get(2).getY();
        double endX = shape.getControlPoints().get(3).getX();
        double endY = shape.getControlPoints().get(3).getY();
        this.curve = shape;
        this.bounding = new BezierCurve(x, y, controlX1, controlY1, controlX2, controlY2, endX, endY);
        this.bounding.setStrokeWidth(10.0);
        this.bounding.setAlpha(0.01);
        this.controlLine1 = new Line(x, y, controlX1, controlY1);
        this.controlLine1.setAlpha(0.5);
        this.controlLine1.setStrokeColor("#0000ff");
        this.controlLine1.setDashArray(2.0, new double[]{2.0});
        this.controlLine2 = new Line(controlX2, controlY2, endX, endY);
        this.controlLine2.setAlpha(0.5);
        this.controlLine2.setStrokeColor("#0000ff");
        this.controlLine2.setDashArray(2.0, new double[]{2.0});
        this.add((IPrimitive)this.curve);
        this.add((IPrimitive)this.bounding);
        this.magnets.clear();
        this.controlPoints.clear();
        this.controlPoint1 = new ConnectibleControlPoint(this.curve.getControlPoints().get(0).getX(), this.curve.getControlPoints().get(0).getY(), (HasControlPoints)this, (MagnetManager)this, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresBezierCurve.this.curve.getControlPoints().get(0).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.curve.getControlPoints().get(0).setY(y - WiresBezierCurve.this.getY());
                WiresBezierCurve.this.bounding.getControlPoints().get(0).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.bounding.getControlPoints().get(0).setY(y - WiresBezierCurve.this.getY());
                WiresBezierCurve.this.controlLine1.getPoints().get(0).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.controlLine1.getPoints().get(0).setY(y - WiresBezierCurve.this.getY());
            }
        });
        this.controlPoint2 = new DefaultControlPoint(this.curve.getControlPoints().get(1).getX(), this.curve.getControlPoints().get(1).getY(), new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresBezierCurve.this.curve.getControlPoints().get(1).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.curve.getControlPoints().get(1).setY(y - WiresBezierCurve.this.getY());
                WiresBezierCurve.this.bounding.getControlPoints().get(1).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.bounding.getControlPoints().get(1).setY(y - WiresBezierCurve.this.getY());
                WiresBezierCurve.this.controlLine1.getPoints().get(1).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.controlLine1.getPoints().get(1).setY(y - WiresBezierCurve.this.getY());
            }
        });
        this.controlPoint3 = new DefaultControlPoint(this.curve.getControlPoints().get(2).getX(), this.curve.getControlPoints().get(2).getY(), new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresBezierCurve.this.curve.getControlPoints().get(2).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.curve.getControlPoints().get(2).setY(y - WiresBezierCurve.this.getY());
                WiresBezierCurve.this.bounding.getControlPoints().get(2).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.bounding.getControlPoints().get(2).setY(y - WiresBezierCurve.this.getY());
                WiresBezierCurve.this.controlLine2.getPoints().get(0).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.controlLine2.getPoints().get(0).setY(y - WiresBezierCurve.this.getY());
            }
        });
        this.controlPoint4 = new ConnectibleControlPoint(this.curve.getControlPoints().get(3).getX(), this.curve.getControlPoints().get(3).getY(), (HasControlPoints)this, (MagnetManager)this, new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                WiresBezierCurve.this.curve.getControlPoints().get(3).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.curve.getControlPoints().get(3).setY(y - WiresBezierCurve.this.getY());
                WiresBezierCurve.this.bounding.getControlPoints().get(3).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.bounding.getControlPoints().get(3).setY(y - WiresBezierCurve.this.getY());
                WiresBezierCurve.this.controlLine2.getPoints().get(1).setX(x - WiresBezierCurve.this.getX());
                WiresBezierCurve.this.controlLine2.getPoints().get(1).setY(y - WiresBezierCurve.this.getY());
            }
        });
        this.addControlPoint((ControlPoint)this.controlPoint1);
        this.addControlPoint(this.controlPoint2);
        this.addControlPoint(this.controlPoint3);
        this.addControlPoint((ControlPoint)this.controlPoint4);
        this.addNodeDragMoveHandler(new NodeDragMoveHandler(){

            public void onNodeDragMove(NodeDragMoveEvent nodeDragMoveEvent) {
                Magnet boundMagnet1 = WiresBezierCurve.this.controlPoint1.getBoundMagnet();
                Magnet boundMagnet4 = WiresBezierCurve.this.controlPoint4.getBoundMagnet();
                if (boundMagnet1 != null) {
                    boundMagnet1.detachControlPoint((ControlPoint)WiresBezierCurve.this.controlPoint1);
                }
                if (boundMagnet4 != null) {
                    boundMagnet4.detachControlPoint((ControlPoint)WiresBezierCurve.this.controlPoint4);
                }
                WiresBezierCurve.this.getLayer().batch();
            }
        });
    }

    public void setMagnetManager(MagnetManager magnetManager) {
        this.magnetManager = magnetManager;
    }

    public void hideAllMagnets() {
        if (this.magnetManager != null) {
            this.magnetManager.hideAllMagnets();
        }
    }

    public Magnet getMagnet(WiresShape shapeActive, double cx, double cy) {
        if (this.magnetManager != null) {
            return this.magnetManager.getMagnet(shapeActive, cx, cy);
        }
        return null;
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.add((IPrimitive)this.controlLine1);
            this.add((IPrimitive)this.controlLine2);
            this.bounding.setAlpha(0.1);
        } else {
            this.remove((IPrimitive)this.controlLine1);
            this.remove((IPrimitive)this.controlLine2);
            this.bounding.setAlpha(0.01);
        }
    }

    public boolean contains(double cx, double cy) {
        return false;
    }
}

