/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.shapes.dynamic;

import com.ait.lienzo.client.core.shape.Circle;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Point2D;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPoint;
import org.uberfire.ext.wires.core.api.controlpoints.ControlPointMoveHandler;
import org.uberfire.ext.wires.core.api.magnets.Magnet;
import org.uberfire.ext.wires.core.client.controlpoints.DefaultControlPoint;
import org.uberfire.ext.wires.core.client.magnets.DefaultMagnet;
import org.uberfire.ext.wires.core.scratchpad.client.shapes.WiresScratchPadDefaultShape;

public class WiresCircle
extends WiresScratchPadDefaultShape {
    private static final int BOUNDARY_SIZE = 10;
    private final Magnet magnet1;
    private final Magnet magnet2;
    private final Magnet magnet3;
    private final Magnet magnet4;
    private final ControlPoint controlPoint1;
    private Circle circle;
    private Circle bounding;

    public WiresCircle(Circle shape) {
        double radius = shape.getRadius();
        this.circle = shape;
        this.bounding = new Circle(radius + 5.0);
        this.bounding.setStrokeWidth(10.0);
        this.bounding.setAlpha(0.1);
        this.add((IPrimitive)this.circle);
        this.magnets.clear();
        this.magnet1 = new DefaultMagnet(this.getX() - radius, this.getY());
        this.magnet2 = new DefaultMagnet(this.getX() + radius, this.getY());
        this.magnet3 = new DefaultMagnet(this.getX(), this.getY() - radius);
        this.magnet4 = new DefaultMagnet(this.getX(), this.getY() + radius);
        this.addMagnet(this.magnet1);
        this.addMagnet(this.magnet2);
        this.addMagnet(this.magnet3);
        this.addMagnet(this.magnet4);
        this.controlPoints.clear();
        this.controlPoint1 = new DefaultControlPoint(this.getX() + radius, this.getY(), new ControlPointMoveHandler(){

            public void onMove(double x, double y) {
                double dx = WiresCircle.this.getX() - x;
                double dy = WiresCircle.this.getY() - y;
                double r = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                WiresCircle.this.magnet1.setX(WiresCircle.this.getX() - r);
                WiresCircle.this.magnet2.setX(WiresCircle.this.getX() + r);
                WiresCircle.this.magnet3.setY(WiresCircle.this.getY() - r);
                WiresCircle.this.magnet4.setY(WiresCircle.this.getY() + r);
                WiresCircle.this.circle.setRadius(r);
                WiresCircle.this.bounding.setRadius(r + 5.0);
            }
        });
        this.addControlPoint(this.controlPoint1);
    }

    public void setSelected(boolean isSelected) {
        if (isSelected) {
            this.add((IPrimitive)this.bounding);
        } else {
            this.remove((IPrimitive)this.bounding);
        }
    }

    public boolean contains(double cx, double cy) {
        double _x = cx - this.getX();
        double _y = cy - this.getY();
        return Math.sqrt(Math.pow(_x, 2.0) + Math.pow(_y, 2.0)) < this.circle.getRadius() + 10.0;
    }

    public double getRadius() {
        return this.circle.getRadius();
    }

    public void setRadius(double radius) {
        this.circle.setRadius(radius);
        this.bounding.setRadius(radius + 5.0);
        double theta = Math.atan(this.controlPoint1.getY() / this.controlPoint1.getX());
        this.controlPoint1.setLocation(new Point2D(this.getX() + radius * Math.cos(theta), this.getY() + radius * Math.sin(theta)));
        this.magnet1.setLocation(new Point2D(this.getX() - radius, this.getY()));
        this.magnet2.setLocation(new Point2D(this.getX() + radius, this.getY()));
        this.magnet3.setLocation(new Point2D(this.getX(), this.getY() - radius));
        this.magnet4.setLocation(new Point2D(this.getX(), this.getY() + radius));
    }
}

