/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.factories.fixed;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.TextMetrics;
import com.ait.lienzo.client.widget.LienzoPanel;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.ait.lienzo.shared.core.types.TextBaseLine;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.ext.wires.core.api.factories.FactoryHelper;
import org.uberfire.ext.wires.core.api.factories.categories.Category;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.factories.AbstractBaseFactory;
import org.uberfire.ext.wires.core.client.factories.categories.FixedShapeCategory;
import org.uberfire.ext.wires.core.scratchpad.client.shapes.fixed.WiresFixedText;

@ApplicationScoped
public class FixedTextFactory
extends AbstractBaseFactory<Text> {
    private static final String DESCRIPTION = "Text";
    private static final int FONT_POINT = 30;
    private final double TEXT_WIDTH;
    private final double TEXT_HEIGHT;

    public FixedTextFactory() {
        Text text = this.makeShape();
        LienzoPanel panel = new LienzoPanel(100, 100);
        Layer layer = new Layer();
        panel.add(layer);
        TextMetrics tm = text.measure(layer.getContext());
        this.TEXT_WIDTH = tm.getWidth();
        this.TEXT_HEIGHT = tm.getHeight();
    }

    public String getShapeDescription() {
        return DESCRIPTION;
    }

    public Category getCategory() {
        return FixedShapeCategory.CATEGORY;
    }

    public WiresBaseShape getShape(FactoryHelper helper) {
        return new WiresFixedText(this.makeShape());
    }

    public boolean builds(WiresBaseShape shapeType) {
        return shapeType instanceof WiresFixedText;
    }

    protected Text makeShape() {
        Text text = new Text("T", "normal", 30.0);
        ((Text)((Text)text.setStrokeColor("#181818")).setFillColor("#181818")).setTextBaseLine(TextBaseLine.MIDDLE).setTextAlign(TextAlign.CENTER).setDraggable(false);
        return text;
    }

    protected double getWidth() {
        return Math.round(this.TEXT_WIDTH);
    }

    protected double getHeight() {
        return Math.round(this.TEXT_HEIGHT);
    }
}

