/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.properties;

import com.google.common.collect.Lists;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.wires.core.api.properties.PropertyEditorAdaptor;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.properties.DoubleValidator;

@ApplicationScoped
public class DefaultPropertyEditorAdaptor
implements PropertyEditorAdaptor {
    private static final String POSITION_NODE = "Position Node";

    public boolean supports(WiresBaseShape shape) {
        return true;
    }

    public List<PropertyEditorCategory> getProperties(final WiresBaseShape shape) {
        PropertyEditorFieldInfo fieldInfo1 = new PropertyEditorFieldInfo("X", String.valueOf(shape.getX()), PropertyEditorType.NATURAL_NUMBER){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                try {
                    double x = Double.parseDouble(currentStringValue);
                    shape.setX(x);
                    shape.getLayer().batch();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        PropertyEditorFieldInfo fieldInfo2 = new PropertyEditorFieldInfo("Y", String.valueOf(shape.getY()), PropertyEditorType.NATURAL_NUMBER){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                try {
                    double y = Double.parseDouble(currentStringValue);
                    shape.setY(y);
                    shape.getLayer().batch();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        fieldInfo1.getValidators().clear();
        fieldInfo2.getValidators().clear();
        fieldInfo1.getValidators().add(new DoubleValidator());
        fieldInfo2.getValidators().add(new DoubleValidator());
        PropertyEditorCategory position = new PropertyEditorCategory(POSITION_NODE).withField(fieldInfo1).withField(fieldInfo2);
        return Lists.newArrayList((Object[])new PropertyEditorCategory[]{position});
    }
}

