/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.core.scratchpad.client.properties;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.wires.core.api.properties.PropertyEditorAdaptor;
import org.uberfire.ext.wires.core.api.shapes.WiresBaseShape;
import org.uberfire.ext.wires.core.client.properties.DoubleValidator;
import org.uberfire.ext.wires.core.scratchpad.client.shapes.dynamic.WiresCircle;

@ApplicationScoped
public class WiresCirclePropertyEditorAdaptor
implements PropertyEditorAdaptor {
    private static final String ATTRIBUTES = "Attributes";

    public boolean supports(WiresBaseShape shape) {
        return shape instanceof WiresCircle;
    }

    public List<PropertyEditorCategory> getProperties(WiresBaseShape shape) {
        if (!this.supports(shape)) {
            return Collections.emptyList();
        }
        final WiresCircle w = (WiresCircle)shape;
        PropertyEditorFieldInfo fieldInfo1 = new PropertyEditorFieldInfo("Radius", String.valueOf(w.getRadius()), PropertyEditorType.NATURAL_NUMBER){

            public void setCurrentStringValue(String currentStringValue) {
                super.setCurrentStringValue(currentStringValue);
                try {
                    double r = Double.parseDouble(currentStringValue);
                    w.setRadius(r);
                    w.getLayer().batch();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        fieldInfo1.getValidators().clear();
        fieldInfo1.getValidators().add(new DoubleValidator());
        PropertyEditorCategory attributes = new PropertyEditorCategory(ATTRIBUTES).withField(fieldInfo1);
        return Lists.newArrayList((Object[])new PropertyEditorCategory[]{attributes});
    }
}

