/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.client.preferences.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.preferences.client.scope.ClientUsernameProvider;
import org.uberfire.ext.preferences.client.store.PreferenceStore;
import org.uberfire.ext.preferences.shared.PreferenceScope;
import org.uberfire.ext.preferences.shared.PreferenceScopeFactory;
import org.uberfire.ext.preferences.shared.PreferenceScopeResolver;
import org.uberfire.ext.preferences.shared.PreferenceScopeTypes;
import org.uberfire.ext.preferences.shared.UsernameProvider;
import org.uberfire.ext.preferences.shared.impl.DefaultPreferenceScopeResolutionStrategy;
import org.uberfire.ext.preferences.shared.impl.DefaultPreferenceScopeResolver;
import org.uberfire.ext.preferences.shared.impl.DefaultPreferenceScopeTypes;
import org.uberfire.ext.preferences.shared.impl.PreferenceScopeFactoryImpl;
import org.uberfire.ext.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.ext.preferences.shared.impl.PreferenceScopedValue;
import org.uberfire.ext.wires.client.preferences.form.PreferencesEditorFormPresenter;
import org.uberfire.ext.wires.client.preferences.form.PreferencesEditorItemPresenter;
import org.uberfire.ext.wires.client.preferences.form.ViewMode;
import org.uberfire.mocks.SessionInfoMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.NotificationEvent;

public class PreferencesEditorFormPresenterTest {
    private PreferencesEditorFormPresenter.View view;
    private PreferenceStore preferenceStore;
    private Event<NotificationEvent> notification;
    private PreferencesEditorFormPresenter presenter;
    private ManagedInstance<PreferencesEditorItemPresenter> editorItemProvider;

    @Before
    public void setup() {
        this.view = (PreferencesEditorFormPresenter.View)Mockito.mock(PreferencesEditorFormPresenter.View.class);
        this.notification = (Event)Mockito.mock(Event.class);
        this.editorItemProvider = (ManagedInstance)Mockito.mock(ManagedInstance.class);
        SessionInfoMock sessionInfo = new SessionInfoMock();
        DefaultPreferenceScopeTypes scopeTypes = new DefaultPreferenceScopeTypes((UsernameProvider)new ClientUsernameProvider((SessionInfo)sessionInfo));
        PreferenceScopeFactoryImpl scopeFactory = new PreferenceScopeFactoryImpl((PreferenceScopeTypes)scopeTypes);
        DefaultPreferenceScopeResolutionStrategy defaultPreferenceScopeResolutionStrategy = new DefaultPreferenceScopeResolutionStrategy((PreferenceScopeFactory)scopeFactory, null);
        PreferenceScopeResolutionStrategyInfo info = defaultPreferenceScopeResolutionStrategy.getInfo();
        this.preferenceStore = (PreferenceStore)Mockito.spy((Object)new PreferenceStore(null, null, info, (PreferenceScopeResolver)new DefaultPreferenceScopeResolver(info.order())));
        ((ManagedInstance)Mockito.doAnswer(invocationOnMock -> this.newPreferencesEditorItemPresenterInstance()).when(this.editorItemProvider)).get();
        HashMap<String, PreferenceScopedValue> map = new HashMap<String, PreferenceScopedValue>();
        map.put("my.first.preference.key", new PreferenceScopedValue((Object)"value1", (PreferenceScope)Mockito.mock(PreferenceScope.class)));
        map.put("my.second.preference.key", new PreferenceScopedValue((Object)"value2", (PreferenceScope)Mockito.mock(PreferenceScope.class)));
        map.put("my.third.preference.key", new PreferenceScopedValue((Object)"value3", (PreferenceScope)Mockito.mock(PreferenceScope.class)));
        ((PreferenceStore)Mockito.doAnswer(invocationOnMock -> {
            ((RemoteCallback)invocationOnMock.getArguments()[1]).callback((Object)map);
            return null;
        }).when((Object)this.preferenceStore)).searchScoped((Collection)Matchers.anyList(), (RemoteCallback)Matchers.any(RemoteCallback.class));
        this.presenter = (PreferencesEditorFormPresenter)Mockito.spy((Object)new PreferencesEditorFormPresenter(this.view, this.notification, this.editorItemProvider));
        ArrayList<String> managedKeys = new ArrayList<String>();
        managedKeys.add("my.first.preference.key");
        managedKeys.add("my.second.preference.key");
        managedKeys.add("my.third.preference.key");
        this.presenter.init(this.preferenceStore, managedKeys, "component title", ViewMode.GLOBAL);
    }

    @Test
    public void managedKeysWereSetTest() {
        List preferencesEditors = this.presenter.getPreferencesEditors();
        Assert.assertEquals((long)3L, (long)preferencesEditors.size());
    }

    @Test
    public void saveWithNoChangesTest() {
        ((PreferencesEditorFormPresenter)Mockito.doReturn(new ArrayList()).when((Object)this.presenter)).getPreferencesEditors();
        this.presenter.save();
        ((Event)Mockito.verify(this.notification)).fire(Matchers.any(NotificationEvent.class));
        ((PreferencesEditorFormPresenter.View)Mockito.verify((Object)this.view)).getNoChangesMessage();
    }

    @Test
    public void saveSuccessTest() {
        ((PreferenceStore)Mockito.doAnswer(invocationOnMock -> {
            ((RemoteCallback)invocationOnMock.getArguments()[3]).callback(null);
            return null;
        }).when((Object)this.preferenceStore)).put((PreferenceScope)Matchers.any(PreferenceScope.class), Matchers.anyString(), (Object)Matchers.anyString(), (RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class));
        this.presenter.save();
        ((Event)Mockito.verify(this.notification, (VerificationMode)Mockito.times((int)3))).fire(Matchers.any(NotificationEvent.class));
        ((PreferencesEditorFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).getPreferencesSavedSuccessfullyMessage(Matchers.anyString());
    }

    @Test
    public void saveFailTest() {
        ((PreferenceStore)Mockito.doAnswer(invocationOnMock -> {
            ((ErrorCallback)invocationOnMock.getArguments()[4]).error(null, (Throwable)new RuntimeException());
            return null;
        }).when((Object)this.preferenceStore)).put((PreferenceScope)Matchers.any(PreferenceScope.class), Matchers.anyString(), (Object)Matchers.anyString(), (RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class));
        this.presenter.save();
        ((Event)Mockito.verify(this.notification, (VerificationMode)Mockito.times((int)3))).fire(Matchers.any(NotificationEvent.class));
        ((PreferencesEditorFormPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).getErrorsWhenSavingMessage(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void undoChangesTest() {
        this.presenter.undoChanges();
        for (PreferencesEditorItemPresenter preferenceEditor : this.presenter.getPreferencesEditors()) {
            ((PreferencesEditorItemPresenter)Mockito.verify((Object)preferenceEditor)).undoChanges();
        }
    }

    private PreferencesEditorItemPresenter newPreferencesEditorItemPresenterInstance() {
        PreferencesEditorItemPresenter.View viewMock = (PreferencesEditorItemPresenter.View)Mockito.mock(PreferencesEditorItemPresenter.View.class);
        PreferencesEditorItemPresenter presenter = new PreferencesEditorItemPresenter(viewMock);
        return (PreferencesEditorItemPresenter)Mockito.spy((Object)presenter);
    }
}

