/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.wires.client.preferences.form;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.ext.preferences.shared.PreferenceScope;
import org.uberfire.ext.wires.client.preferences.form.PreferencesEditorItemPresenter;
import org.uberfire.ext.wires.client.preferences.form.ViewMode;

public class PreferencesEditorItemPresenterTest {
    private PreferencesEditorItemPresenter.View view;
    private PreferencesEditorItemPresenter presenter;

    @Before
    public void setup() {
        this.view = (PreferencesEditorItemPresenter.View)Mockito.mock(PreferencesEditorItemPresenter.View.class);
        this.presenter = new PreferencesEditorItemPresenter(this.view);
        this.presenter.setViewMode(ViewMode.GLOBAL);
        this.presenter.setPersistedPreferenceValue((Object)"persistedValue");
        this.presenter.setPersistedPreferenceScope((PreferenceScope)Mockito.mock(PreferenceScope.class));
    }

    @Test
    public void preferenceShouldNotBePersistedWhenTheValueIsNotModifiedTest() {
        ((PreferencesEditorItemPresenter.View)Mockito.doReturn((Object)"persistedValue").when((Object)this.view)).getNewPreferenceValue();
        Assert.assertFalse((boolean)this.presenter.shouldBePersisted());
    }

    @Test
    public void preferenceShouldBePersistedWhenTheValueIsModifiedTest() {
        ((PreferencesEditorItemPresenter.View)Mockito.doReturn((Object)"newValue").when((Object)this.view)).getNewPreferenceValue();
        Assert.assertTrue((boolean)this.presenter.shouldBePersisted());
    }
}

