/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.wires.client.social.perspective;

import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.annotations.WorkbenchPanel;
import org.uberfire.client.annotations.WorkbenchPerspective;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;

@Templated
@Dependent
@WorkbenchPerspective(identifier = "SocialPerspective")
public class SocialPerspective implements IsElement {

    @Inject
    @DataField
    @WorkbenchPanel(parts = "SimpleTimelinePresenter")
    Div simpleTimelinePresenter;

    @Inject
    @DataField
    @WorkbenchPanel(parts = "SocialTimelinePresenter")
    Div socialTimelinePresenter;

}
