/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.wires.shared.preferences.bean;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.annotation.Generated;

import org.uberfire.annotations.Customizable;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.bean.BasePreferenceBean;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.PreferenceBeanStore;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
@Generated("org.uberfire.ext.preferences.processors.WorkbenchPreferenceProcessor")
/*
* WARNING! This class is generated. Do not modify.
*/
public class MyPreferenceBeanGeneratedImpl extends MyPreference implements BasePreferenceBean<MyPreference> {

    private PreferenceBeanStore store;
    
    private PreferenceScopeResolutionStrategy resolutionStrategy;

    @Inject
    public MyPreferenceBeanGeneratedImpl( final PreferenceBeanStore store,
                               @Customizable final PreferenceScopeResolutionStrategy resolutionStrategy ) {
        this.store = store;
        this.resolutionStrategy = resolutionStrategy;
    }

    @Override
    public void load() {
        load( ( ParameterizedCommand<Throwable> ) null );
    }

    @Override
    public void load( final ParameterizedCommand<Throwable> errorCallback ) {
        load( ( ParameterizedCommand<MyPreference> ) null, errorCallback );
    }

    @Override
    public void load( final ParameterizedCommand<MyPreference> successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        final MyPreferenceBeanGeneratedImpl preferenceBean = this;

        store.load( new MyPreferencePortableGeneratedImpl(),
                    getLoadSuccessCallback( successCallback ),
                    errorCallback );
    }

    @Override
    public void load( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy ) {
        load( customScopeResolutionStrategy, null );
    }

    @Override
    public void load( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        load( customScopeResolutionStrategy, null, errorCallback );
    }

    @Override
    public void load( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final ParameterizedCommand<MyPreference> successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        final MyPreferenceBeanGeneratedImpl preferenceBean = this;

        store.load( new MyPreferencePortableGeneratedImpl(),
                    customScopeResolutionStrategy,
                    getLoadSuccessCallback( successCallback ),
                    errorCallback );
    }

    private ParameterizedCommand<BasePreferencePortable<MyPreference>> getLoadSuccessCallback( final ParameterizedCommand<MyPreference> successCallback ) {
        final MyPreferenceBeanGeneratedImpl preferenceBean = this;

        return new ParameterizedCommand<BasePreferencePortable<MyPreference>>() {
            @Override
            public void execute( final BasePreferencePortable<MyPreference> portablePreference ) {
                copy( (MyPreferencePortableGeneratedImpl) portablePreference, preferenceBean );
                if ( successCallback != null ) {
                    successCallback.execute( preferenceBean );
                }
            }
        };
    }

    private void copy( final MyPreference from,
                       final MyPreference to ) {
        to.text = from.text;
        to.sendReports = from.sendReports;
        to.backgroundColor = from.backgroundColor;
        to.age = from.age;
        to.password = from.password;
        to.myInnerPreference = from.myInnerPreference;
        to.mySharedPreference = from.mySharedPreference;
    }

    @Override
    public void save() {
        save( ( ParameterizedCommand<Throwable> ) null );
    }

    @Override
    public void save( final ParameterizedCommand<Throwable> errorCallback ) {
        save( ( Command ) null, errorCallback );
    }

    @Override
    public void save( final Command successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        store.save( createPortableCopy(),
                    successCallback,
                    errorCallback );
    }

    @Override
    public void save( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy ) {
        save( customScopeResolutionStrategy, null );
    }

    @Override
    public void save( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        save( customScopeResolutionStrategy, null, errorCallback );
    }

    @Override
    public void save( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final Command successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        store.save( createPortableCopy(),
                    customScopeResolutionStrategy,
                    successCallback,
                    errorCallback );
    }

    @Override
    public void save( final PreferenceScope customScope ) {
        save( customScope, null );
    }

    @Override
    public void save( final PreferenceScope customScope,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        save( customScope, null, errorCallback );
    }

    @Override
    public void save( final PreferenceScope customScope,
                      final Command successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        store.save( createPortableCopy(),
                    customScope,
                    successCallback,
                    errorCallback );
    }

    private BasePreferencePortable<MyPreference> createPortableCopy() {
        MyPreferencePortableGeneratedImpl portablePreference = new MyPreferencePortableGeneratedImpl();

        copy( this, portablePreference );

        return portablePreference;
    }
}
